/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.network.netty;

import com.google.common.collect.Sets;
import java.net.InetSocketAddress;
import java.util.Set;
import org.apache.log4j.Logger;
import org.restcomm.media.control.mgcp.message.MessageDirection;
import org.restcomm.media.control.mgcp.message.MgcpMessage;
import org.restcomm.media.control.mgcp.message.MgcpMessageObserver;
import org.restcomm.media.control.mgcp.message.MgcpMessageSubject;
import org.restcomm.media.control.mgcp.network.netty.MgcpChannelInboundHandler;
import org.restcomm.media.network.netty.channel.AsyncNettyNetworkChannel;
import org.restcomm.media.network.netty.channel.NettyNetworkChannelGlobalContext;

public class AsyncMgcpChannel
extends AsyncNettyNetworkChannel<MgcpMessage>
implements MgcpMessageObserver,
MgcpMessageSubject {
    private static final Logger log = Logger.getLogger(AsyncMgcpChannel.class);
    private final Set<MgcpMessageObserver> observers;

    public AsyncMgcpChannel(NettyNetworkChannelGlobalContext context, MgcpChannelInboundHandler handler) {
        super(context);
        handler.observe(this);
        this.observers = Sets.newConcurrentHashSet();
    }

    @Override
    public void observe(MgcpMessageObserver observer) {
        this.observers.add(observer);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Registered MgcpMessageObserver@" + observer.hashCode() + ". Count: " + this.observers.size()));
        }
    }

    @Override
    public void forget(MgcpMessageObserver observer) {
        this.observers.remove(observer);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Unregistered MgcpMessageObserver@" + observer.hashCode() + ". Count: " + this.observers.size()));
        }
    }

    @Override
    public void notify(Object originator, InetSocketAddress from, InetSocketAddress to, MgcpMessage message, MessageDirection direction) {
        for (MgcpMessageObserver observer : this.observers) {
            if (observer == originator) continue;
            observer.onMessage(from, to, message, direction);
        }
    }

    @Override
    public void onMessage(InetSocketAddress from, InetSocketAddress to, MgcpMessage message, MessageDirection direction) {
        this.notify(this, from, to, message, direction);
    }
}

