/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.log4j.Logger;
import org.restcomm.media.control.mgcp.exception.MgcpParseException;
import org.restcomm.media.control.mgcp.message.MgcpMessage;
import org.restcomm.media.control.mgcp.message.MgcpMessageParser;
import org.restcomm.media.control.mgcp.message.MgcpRequest;
import org.restcomm.media.control.mgcp.message.MgcpResponse;
import org.restcomm.media.control.mgcp.network.netty.MgcpMessageEnvelope;

public class MgcpMessageDecoder
extends MessageToMessageDecoder<DatagramPacket> {
    private static final Logger log = Logger.getLogger(MgcpMessageDecoder.class);
    public static final String PIPELINE_KEY = "mgcp-decoder";
    private final MgcpMessageParser parser;

    public MgcpMessageDecoder(MgcpMessageParser parser) {
        this.parser = parser;
    }

    private MgcpRequest handleRequest(byte[] packet) throws MgcpParseException {
        return this.parser.parseRequest(packet, 0, packet.length);
    }

    private MgcpResponse handleResponse(byte[] packet) throws MgcpParseException {
        return this.parser.parseResponse(packet, 0, packet.length);
    }

    protected void decode(ChannelHandlerContext ctx, DatagramPacket msg, List<Object> out) throws Exception {
        ByteBuf content = (ByteBuf)msg.content();
        InetSocketAddress recipient = (InetSocketAddress)msg.recipient();
        InetSocketAddress sender = (InetSocketAddress)msg.sender();
        byte[] payload = new byte[content.readableBytes()];
        content.getBytes(0, payload);
        byte b = payload[0];
        MgcpMessage message = b >= 48 && b <= 57 ? this.handleResponse(payload) : this.handleRequest(payload);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Incoming MGCP message from " + sender.toString() + ":\n\n" + message.toString() + "\n"));
        }
        MgcpMessageEnvelope envelope = new MgcpMessageEnvelope(message, recipient, sender);
        out.add((Object)envelope);
    }
}

