/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import org.apache.log4j.Logger;
import org.restcomm.media.control.mgcp.message.MgcpMessage;

public class MgcpMessageEncoder
extends MessageToMessageEncoder<DefaultAddressedEnvelope<MgcpMessage, SocketAddress>> {
    private static final Logger log = Logger.getLogger(MgcpMessageEncoder.class);
    public static final String PIPELINE_KEY = "mgcp-encoder";

    protected void encode(ChannelHandlerContext ctx, DefaultAddressedEnvelope<MgcpMessage, SocketAddress> msg, List<Object> out) throws Exception {
        InetSocketAddress sender = (InetSocketAddress)msg.sender();
        InetSocketAddress recipient = (InetSocketAddress)msg.recipient();
        byte[] content = ((MgcpMessage)msg.content()).toString().getBytes();
        ByteBuf buffer = Unpooled.buffer((int)content.length).writeBytes(content);
        DatagramPacket packet = new DatagramPacket(buffer, recipient, sender);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending outgoing message to " + recipient.getHostString() + "\n" + msg.toString()));
        }
        out.add(packet);
    }
}

