/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.pkg;

import java.util.HashMap;
import java.util.Map;
import org.restcomm.media.control.mgcp.pkg.MgcpEvent;

public class GenericMgcpEvent
implements MgcpEvent {
    protected final String pkg;
    protected final String symbol;
    protected final String signal;
    protected final int connectionId;
    protected final Map<String, String> parameters;
    protected final StringBuilder builder;

    private GenericMgcpEvent(String pkg, String symbol, String signal, int connectionId) {
        this.pkg = pkg;
        this.symbol = symbol;
        this.signal = signal;
        this.connectionId = connectionId;
        this.parameters = new HashMap<String, String>(5);
        this.builder = new StringBuilder();
    }

    public GenericMgcpEvent(String pkg, String symbol, int connectionId) {
        this(pkg, symbol, "", connectionId);
    }

    public GenericMgcpEvent(String pkg, String symbol, String signal) {
        this(pkg, symbol, signal, 0);
    }

    @Override
    public String getPackage() {
        return this.pkg;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public int getConnectionId() {
        return this.connectionId;
    }

    @Override
    public String getSignal() {
        return this.signal;
    }

    @Override
    public String getParameter(String type) {
        return this.parameters.get(type);
    }

    public void setParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public String toString() {
        this.builder.setLength(0);
        this.builder.append(this.pkg).append("/").append(this.symbol);
        if (this.connectionId > 0) {
            this.builder.append("@").append(this.connectionId);
        }
        this.builder.append("(").append(this.pkg).append("/").append(this.signal);
        if (!this.parameters.isEmpty()) {
            for (String key : this.parameters.keySet()) {
                String value = this.parameters.get(key);
                this.builder.append(" ").append(key);
                if (value == null) continue;
                this.builder.append("=").append(value);
            }
        }
        this.builder.append(")");
        return this.builder.toString();
    }
}

