/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.pkg;

import org.restcomm.media.control.mgcp.exception.MgcpParseException;
import org.restcomm.media.control.mgcp.pkg.MgcpActionType;
import org.restcomm.media.control.mgcp.pkg.MgcpEventType;
import org.restcomm.media.control.mgcp.pkg.MgcpPackage;
import org.restcomm.media.control.mgcp.pkg.MgcpPackageManager;
import org.restcomm.media.control.mgcp.pkg.MgcpRequestedEvent;
import org.restcomm.media.control.mgcp.pkg.exception.UnrecognizedMgcpActionException;
import org.restcomm.media.control.mgcp.pkg.exception.UnrecognizedMgcpEventException;
import org.restcomm.media.control.mgcp.pkg.exception.UnrecognizedMgcpPackageException;

public class MgcpRequestedEventsParser {
    private static final String EVENT_SEPARATOR = "/";
    private static final String CONNECTION_ID_SEPARATOR = "@";
    private static final String ACTION_START_SEPARATOR = "(";
    private static final String ACTION_END_SEPARATOR = ")";
    private static final String PARAMETER_START_SEPARATOR = "(";
    private static final String PARAMETER_END_SEPARATOR = ")";

    public static MgcpRequestedEvent[] parse(int requestId, String requestedEvents, MgcpPackageManager packageManager) throws UnrecognizedMgcpPackageException, UnrecognizedMgcpEventException, UnrecognizedMgcpActionException, MgcpParseException {
        String[] tokens = requestedEvents.split("(?<=\\)),");
        MgcpRequestedEvent[] events = new MgcpRequestedEvent[tokens.length];
        for (int i = 0; i < events.length; ++i) {
            events[i] = MgcpRequestedEventsParser.parseSingle(requestId, tokens[i], packageManager);
        }
        return events;
    }

    private static MgcpRequestedEvent parseSingle(int requestId, String requestedEvent, MgcpPackageManager packageManager) throws UnrecognizedMgcpPackageException, UnrecognizedMgcpEventException, UnrecognizedMgcpActionException, MgcpParseException {
        int indexOfEvent = requestedEvent.indexOf(EVENT_SEPARATOR);
        if (indexOfEvent == -1) {
            throw new UnrecognizedMgcpPackageException("Missing event name separator on " + requestedEvent);
        }
        int indexOfConnectionId = requestedEvent.indexOf(CONNECTION_ID_SEPARATOR);
        int indexOfActionStart = requestedEvent.indexOf("(");
        if (indexOfActionStart == -1) {
            throw new MgcpParseException("Missing action start separator on " + requestedEvent);
        }
        int indexOfActionEnd = requestedEvent.indexOf(")");
        if (indexOfActionEnd == -1) {
            throw new MgcpParseException("Missing action end separator on " + requestedEvent);
        }
        try {
            String action;
            MgcpActionType actionType;
            String packageName = requestedEvent.substring(0, indexOfEvent);
            MgcpPackage mgcpPackage = packageManager.getPackage(packageName);
            if (mgcpPackage == null) {
                throw new UnrecognizedMgcpPackageException("Unrecognized package " + packageName + " on " + requestedEvent);
            }
            String eventName = indexOfConnectionId == -1 ? requestedEvent.substring(indexOfEvent + 1, indexOfActionStart) : requestedEvent.substring(indexOfEvent + 1, indexOfConnectionId);
            MgcpEventType eventDetails = mgcpPackage.getEventDetails(eventName);
            if (eventDetails == null) {
                throw new UnrecognizedMgcpEventException("Unrecognized event " + eventName + " on " + requestedEvent);
            }
            String connectionIdHex = "";
            if (indexOfConnectionId != -1 && !(connectionIdHex = requestedEvent.substring(indexOfConnectionId + 1, indexOfActionStart)).matches("^[0-9A-F]+$")) {
                throw new MgcpParseException("Invalid connection identifier " + connectionIdHex + " on " + requestedEvent);
            }
            String eventParameters = "";
            boolean parameterized = eventDetails.parameterized();
            if (parameterized) {
                int indexOfParameterStart = requestedEvent.indexOf("(", indexOfActionEnd);
                if (indexOfParameterStart == -1) {
                    throw new MgcpParseException("Missing parameters start separator on " + requestedEvent);
                }
                int indexOfParameterEnd = requestedEvent.indexOf(")", indexOfParameterStart);
                if (indexOfActionEnd == -1) {
                    throw new MgcpParseException("Missing parameters end separator on " + requestedEvent);
                }
                eventParameters = requestedEvent.substring(indexOfParameterStart + 1, indexOfParameterEnd);
            }
            if ((actionType = MgcpActionType.fromSymbol(action = requestedEvent.substring(indexOfActionStart + 1, indexOfActionEnd))) == null) {
                throw new UnrecognizedMgcpActionException("Unrecognized action " + eventName + " on " + requestedEvent);
            }
            int connectionId = connectionIdHex.isEmpty() ? 0 : Integer.parseInt(connectionIdHex, 16);
            String[] eventParametersTokens = eventParameters.isEmpty() ? new String[]{} : eventParameters.split(",");
            return new MgcpRequestedEvent(requestId, packageName, eventName, actionType, connectionId, eventParametersTokens);
        }
        catch (RuntimeException e) {
            throw new MgcpParseException("Could not parse requested event " + requestedEvent, e);
        }
    }
}

