/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.pkg.au.pc;

import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import java.util.Map;
import org.restcomm.media.control.mgcp.command.param.NotifiedEntity;
import org.restcomm.media.control.mgcp.pkg.AbstractMgcpSignal;
import org.restcomm.media.control.mgcp.pkg.SignalType;
import org.restcomm.media.control.mgcp.pkg.au.SignalParameters;
import org.restcomm.media.control.mgcp.pkg.au.pc.PlayCollectContext;
import org.restcomm.media.control.mgcp.pkg.au.pc.PlayCollectEvent;
import org.restcomm.media.control.mgcp.pkg.au.pc.PlayCollectFsm;
import org.restcomm.media.control.mgcp.pkg.au.pc.PlayCollectFsmBuilder;
import org.restcomm.media.spi.dtmf.DtmfDetector;
import org.restcomm.media.spi.dtmf.DtmfDetectorListener;
import org.restcomm.media.spi.dtmf.DtmfEvent;
import org.restcomm.media.spi.player.Player;
import org.restcomm.media.spi.player.PlayerEvent;
import org.restcomm.media.spi.player.PlayerListener;

public class PlayCollect
extends AbstractMgcpSignal {
    static final String SYMBOL = "pc";
    private final PlayCollectFsm fsm;
    private final DtmfDetector detector;
    final DtmfDetectorListener detectorListener;
    private final Player player;
    final PlayerListener playerListener;
    private final PlayCollectContext context;

    public PlayCollect(Player player, DtmfDetector detector, int requestId, NotifiedEntity notifiedEntity, Map<String, String> parameters, ListeningScheduledExecutorService executor) {
        super("AU", SYMBOL, SignalType.TIME_OUT, requestId, notifiedEntity, parameters);
        this.detector = detector;
        this.detectorListener = new DetectorListener();
        this.player = player;
        this.playerListener = new AudioPlayerListener();
        this.context = new PlayCollectContext(detector, this.detectorListener, parameters);
        this.fsm = PlayCollectFsmBuilder.INSTANCE.build(detector, this.detectorListener, player, this.playerListener, this, executor, this.context);
    }

    public PlayCollect(Player player, DtmfDetector detector, int requestId, Map<String, String> parameters, ListeningScheduledExecutorService executor) {
        this(player, detector, requestId, null, parameters, executor);
    }

    @Override
    protected boolean isParameterSupported(String name) {
        SignalParameters parameter = SignalParameters.fromSymbol(name);
        if (parameter == null) {
            return false;
        }
        switch (parameter) {
            case INITIAL_PROMPT: 
            case REPROMPT: 
            case NO_DIGITS_REPROMPT: 
            case FAILURE_ANNOUNCEMENT: 
            case SUCCESS_ANNOUNCEMENT: 
            case NON_INTERRUPTIBLE_PLAY: 
            case SPEED: 
            case VOLUME: 
            case CLEAR_DIGIT_BUFFER: 
            case MAXIMUM_NUM_DIGITS: 
            case MINIMUM_NUM_DIGITS: 
            case DIGIT_PATTERN: 
            case FIRST_DIGIT_TIMER: 
            case INTER_DIGIT_TIMER: 
            case EXTRA_DIGIT_TIMER: 
            case RESTART_KEY: 
            case REINPUT_KEY: 
            case RETURN_KEY: 
            case POSITION_KEY: 
            case STOP_KEY: 
            case START_INPUT_KEY: 
            case END_INPUT_KEY: 
            case INCLUDE_END_INPUT_KEY: 
            case NUMBER_OF_ATTEMPTS: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void execute() {
        if (!this.fsm.isStarted()) {
            this.fsm.start(this.context);
        }
    }

    @Override
    public void cancel() {
        if (this.fsm.isStarted()) {
            this.fsm.fire((Object)PlayCollectEvent.CANCEL, this.context);
        }
    }

    private final class AudioPlayerListener
    implements PlayerListener {
        private AudioPlayerListener() {
        }

        public void process(PlayerEvent event) {
            switch (event.getID()) {
                case 2: {
                    PlayCollect.this.fsm.fire((Object)PlayCollectEvent.NEXT_TRACK, PlayCollect.this.context);
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
    }

    private final class DetectorListener
    implements DtmfDetectorListener {
        private DetectorListener() {
        }

        public void process(DtmfEvent event) {
            char tone = event.getTone().charAt(0);
            PlayCollect.this.context.setLastTone(tone);
            PlayCollect.this.fsm.fire((Object)PlayCollectEvent.DTMF_TONE, PlayCollect.this.context);
        }
    }
}

