/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.pkg.au.pc;

import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import java.net.MalformedURLException;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.restcomm.media.control.mgcp.pkg.MgcpEventSubject;
import org.restcomm.media.control.mgcp.pkg.au.OperationComplete;
import org.restcomm.media.control.mgcp.pkg.au.OperationFailed;
import org.restcomm.media.control.mgcp.pkg.au.Playlist;
import org.restcomm.media.control.mgcp.pkg.au.ReturnCode;
import org.restcomm.media.control.mgcp.pkg.au.pc.PlayCollectContext;
import org.restcomm.media.control.mgcp.pkg.au.pc.PlayCollectEvent;
import org.restcomm.media.control.mgcp.pkg.au.pc.PlayCollectFsm;
import org.restcomm.media.control.mgcp.pkg.au.pc.PlayCollectState;
import org.restcomm.media.spi.ResourceUnavailableException;
import org.restcomm.media.spi.dtmf.DtmfDetector;
import org.restcomm.media.spi.dtmf.DtmfDetectorListener;
import org.restcomm.media.spi.listener.TooManyListenersException;
import org.restcomm.media.spi.player.Player;
import org.restcomm.media.spi.player.PlayerListener;
import org.squirrelframework.foundation.fsm.impl.AbstractStateMachine;

public class PlayCollectFsmImpl
extends AbstractStateMachine<PlayCollectFsm, PlayCollectState, PlayCollectEvent, PlayCollectContext>
implements PlayCollectFsm {
    private static final Logger log = Logger.getLogger(PlayCollectFsmImpl.class);
    private final ListeningScheduledExecutorService executor;
    private final MgcpEventSubject mgcpEventSubject;
    private final DtmfDetector detector;
    final DtmfDetectorListener detectorListener;
    private final Player player;
    final PlayerListener playerListener;
    private final PlayCollectContext context;

    public PlayCollectFsmImpl(DtmfDetector detector, DtmfDetectorListener detectorListener, Player player, PlayerListener playerListener, MgcpEventSubject mgcpEventSubject, ListeningScheduledExecutorService executor, PlayCollectContext context) {
        this.executor = executor;
        this.mgcpEventSubject = mgcpEventSubject;
        this.detector = detector;
        this.detectorListener = detectorListener;
        this.player = player;
        this.playerListener = playerListener;
        this.context = context;
    }

    private void playAnnouncement(String url, long delay) {
        try {
            this.player.setInitialDelay(delay);
            this.player.setURL(url);
            this.player.activate();
        }
        catch (MalformedURLException e) {
            log.warn((Object)("Could not play malformed segment " + url));
            this.context.setReturnCode(ReturnCode.BAD_AUDIO_ID.code());
            this.fire((Object)PlayCollectEvent.FAIL, this.context);
        }
        catch (ResourceUnavailableException e) {
            log.warn((Object)("Could not play unavailable segment " + url));
            this.context.setReturnCode(ReturnCode.BAD_AUDIO_ID.code());
            this.fire((Object)PlayCollectEvent.FAIL, this.context);
        }
    }

    @Override
    public void enterPlayCollect(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entered PLAY_COLLECT state");
        }
    }

    @Override
    public void exitPlayCollect(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exited PLAY_COLLECT state");
        }
    }

    @Override
    public void enterLoadingPlaylist(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entered LOADING PLAYLIST state");
        }
        if (event == null) {
            Playlist prompt = context.getInitialPrompt();
            if (prompt.isEmpty()) {
                this.fire((Object)PlayCollectEvent.NO_PROMPT, context);
            } else {
                this.fire((Object)PlayCollectEvent.PROMPT, context);
            }
        } else {
            switch (event) {
                case RESTART: {
                    Playlist reprompt = context.getReprompt();
                    if (reprompt.isEmpty()) {
                        this.fire((Object)PlayCollectEvent.NO_PROMPT, context);
                        break;
                    }
                    this.fire((Object)PlayCollectEvent.REPROMPT, context);
                    break;
                }
                case NO_DIGITS: {
                    Playlist noDigitsReprompt = context.getNoDigitsReprompt();
                    if (noDigitsReprompt.isEmpty()) {
                        this.fire((Object)PlayCollectEvent.NO_PROMPT, context);
                        break;
                    }
                    this.fire((Object)PlayCollectEvent.NO_DIGITS, context);
                    break;
                }
                default: {
                    this.fire((Object)PlayCollectEvent.NO_PROMPT, context);
                }
            }
        }
    }

    @Override
    public void exitLoadingPlaylist(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exited LOADING PLAYLIST state");
        }
    }

    @Override
    public void enterPrompting(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entered PROMPTING state");
        }
        Playlist prompt = context.getInitialPrompt();
        String track = prompt.next();
        try {
            this.player.addListener(this.playerListener);
            this.playAnnouncement(track, 0L);
        }
        catch (TooManyListenersException e) {
            log.error((Object)"Too many player listeners", (Throwable)e);
            context.setReturnCode(ReturnCode.UNSPECIFIED_FAILURE.code());
            this.fire((Object)PlayCollectEvent.FAIL, context);
        }
    }

    @Override
    public void onPrompting(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        Playlist prompt;
        String track;
        if (log.isTraceEnabled()) {
            log.trace((Object)"On PROMPTING state");
        }
        if ((track = (prompt = context.getInitialPrompt()).next()).isEmpty()) {
            this.fire((Object)PlayCollectEvent.END_PROMPT, context);
        } else {
            this.playAnnouncement(track, 1000L);
        }
    }

    @Override
    public void exitPrompting(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exited PROMPTING state");
        }
        this.player.removeListener(this.playerListener);
        this.player.deactivate();
    }

    @Override
    public void enterReprompting(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entered REPROMPTING state");
        }
        Playlist prompt = context.getReprompt();
        String track = prompt.next();
        try {
            this.player.addListener(this.playerListener);
            this.playAnnouncement(track, 0L);
        }
        catch (TooManyListenersException e) {
            log.error((Object)"Too many player listeners", (Throwable)e);
            context.setReturnCode(ReturnCode.UNSPECIFIED_FAILURE.code());
            this.fire((Object)PlayCollectEvent.FAIL, context);
        }
    }

    @Override
    public void onReprompting(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        Playlist prompt;
        String track;
        if (log.isTraceEnabled()) {
            log.trace((Object)"On REPROMPTING state");
        }
        if ((track = (prompt = context.getReprompt()).next()).isEmpty()) {
            this.fire((Object)PlayCollectEvent.END_PROMPT, context);
        } else {
            this.playAnnouncement(track, 1000L);
        }
    }

    @Override
    public void exitReprompting(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exited REPROMPTING state");
        }
        this.player.removeListener(this.playerListener);
        this.player.deactivate();
    }

    @Override
    public void enterNoDigitsReprompting(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entered NO DIGITS REPROMPTING state");
        }
        Playlist prompt = context.getNoDigitsReprompt();
        String track = prompt.next();
        try {
            this.player.addListener(this.playerListener);
            this.playAnnouncement(track, 0L);
        }
        catch (TooManyListenersException e) {
            log.error((Object)"Too many player listeners", (Throwable)e);
            context.setReturnCode(ReturnCode.UNSPECIFIED_FAILURE.code());
            this.fire((Object)PlayCollectEvent.FAIL, context);
        }
    }

    @Override
    public void onNoDigitsReprompting(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        Playlist prompt;
        String track;
        if (log.isTraceEnabled()) {
            log.trace((Object)"On NO DIGITS REPROMPTING state");
        }
        if ((track = (prompt = context.getNoDigitsReprompt()).next()).isEmpty()) {
            this.fire((Object)PlayCollectEvent.END_PROMPT, context);
        } else {
            this.playAnnouncement(track, 1000L);
        }
    }

    @Override
    public void exitNoDigitsReprompting(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exited NO DIGITS REPROMPTING state");
        }
        this.player.removeListener(this.playerListener);
        this.player.deactivate();
    }

    @Override
    public void enterPrompted(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        if (context.countCollectedDigits() == 0) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Scheduled First Digit Timer to fire in " + context.getFirstDigitTimer() + " ms"));
            }
            this.executor.schedule((Runnable)new DetectorTimer(context), (long)context.getFirstDigitTimer(), TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void enterCollecting(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entered COLLECTING state");
        }
        try {
            this.detector.addListener(this.detectorListener);
            this.detector.activate();
        }
        catch (TooManyListenersException e) {
            log.error((Object)"Too many DTMF listeners", (Throwable)e);
        }
    }

    @Override
    public void onCollecting(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("On COLLECTING state [digits=" + context.getCollectedDigits() + ", attempt=" + context.getAttempt() + "]"));
        }
        if (!context.getNonInterruptibleAudio()) {
            this.fire((Object)PlayCollectEvent.END_PROMPT, context);
        }
        char tone = context.getLastTone();
        if (context.getReinputKey() == tone) {
            context.collectDigit(tone);
            this.fire((Object)PlayCollectEvent.REINPUT, context);
        } else if (context.getRestartKey() == tone) {
            context.collectDigit(tone);
            this.fire((Object)PlayCollectEvent.RESTART, context);
        } else if (context.getEndInputKey() == tone) {
            this.fire((Object)PlayCollectEvent.END_INPUT, context);
        } else {
            if (context.countCollectedDigits() == 0 && context.getStartInputKeys().indexOf(tone) == -1) {
                log.info((Object)("Dropping tone " + tone + " because it does not match any of StartInputKeys " + context.getStartInputKeys()));
                return;
            }
            context.collectDigit(tone);
            if (!context.hasDigitPattern() && context.countCollectedDigits() == context.getMaximumDigits()) {
                this.fire((Object)PlayCollectEvent.END_INPUT, context);
            } else {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Scheduled Inter Digit Timer to fire in " + context.getFirstDigitTimer() + " ms"));
                }
                this.executor.schedule((Runnable)new DetectorTimer(context), (long)context.getInterDigitTimer(), TimeUnit.MILLISECONDS);
            }
        }
    }

    @Override
    public void exitCollecting(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exited COLLECTING state");
        }
        this.detector.removeListener(this.detectorListener);
        this.detector.deactivate();
    }

    @Override
    public void enterEvaluating(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        int digitCount;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entered EVALUATING state.");
        }
        if ((digitCount = context.countCollectedDigits()) == 0) {
            this.fire((Object)PlayCollectEvent.NO_DIGITS, context);
        } else if (context.hasDigitPattern()) {
            if (context.getCollectedDigits().matches(context.getDigitPattern())) {
                this.fire((Object)PlayCollectEvent.SUCCEED, context);
            } else {
                this.fire((Object)PlayCollectEvent.PATTERN_MISMATCH, context);
            }
        } else if (digitCount < context.getMinimumDigits()) {
            this.fire((Object)PlayCollectEvent.PATTERN_MISMATCH, context);
        } else {
            this.fire((Object)PlayCollectEvent.SUCCEED, context);
        }
    }

    @Override
    public void exitEvaluating(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exited EVALUATING state");
        }
    }

    @Override
    public void enterCanceled(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        int digitCount;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entered CANCELED state");
        }
        if ((digitCount = context.countCollectedDigits()) == 0) {
            context.setReturnCode(ReturnCode.NO_DIGITS.code());
            this.fire((Object)PlayCollectEvent.FAIL, context);
        } else if (context.hasDigitPattern()) {
            if (context.getCollectedDigits().matches(context.getDigitPattern())) {
                this.fire((Object)PlayCollectEvent.SUCCEED, context);
            } else {
                context.setReturnCode(ReturnCode.DIGIT_PATTERN_NOT_MATCHED.code());
                this.fire((Object)PlayCollectEvent.FAIL, context);
            }
        } else if (digitCount < context.getMinimumDigits()) {
            context.setReturnCode(ReturnCode.DIGIT_PATTERN_NOT_MATCHED.code());
            this.fire((Object)PlayCollectEvent.FAIL, context);
        } else {
            this.fire((Object)PlayCollectEvent.SUCCEED, context);
        }
    }

    @Override
    public void exitCanceled(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exited CANCELED state");
        }
    }

    @Override
    public void enterSucceeding(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        Playlist prompt;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entered SUCCEEDING state");
        }
        if ((prompt = context.getSuccessAnnouncement()).isEmpty()) {
            this.fire((Object)PlayCollectEvent.NO_PROMPT, context);
        } else {
            this.fire((Object)PlayCollectEvent.PROMPT, context);
        }
    }

    @Override
    public void exitSucceeding(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entered SUCCEEDING state");
        }
    }

    @Override
    public void enterPlayingSuccess(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entered PLAYING SUCCESS state");
        }
        Playlist prompt = context.getSuccessAnnouncement();
        String track = prompt.next();
        try {
            this.player.addListener(this.playerListener);
            this.playAnnouncement(track, 0L);
        }
        catch (TooManyListenersException e) {
            log.error((Object)"Too many player listeners", (Throwable)e);
            context.setReturnCode(ReturnCode.UNSPECIFIED_FAILURE.code());
            this.fire((Object)PlayCollectEvent.FAIL, context);
        }
    }

    @Override
    public void onPlayingSuccess(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        Playlist prompt;
        String track;
        if (log.isTraceEnabled()) {
            log.trace((Object)"On PLAYING SUCCESS state");
        }
        if ((track = (prompt = context.getSuccessAnnouncement()).next()).isEmpty()) {
            this.fire((Object)PlayCollectEvent.END_PROMPT, context);
        } else {
            this.playAnnouncement(track, 1000L);
        }
    }

    @Override
    public void exitPlayingSuccess(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exited PLAYING SUCCESS state");
        }
        this.player.removeListener(this.playerListener);
        this.player.deactivate();
    }

    @Override
    public void enterSucceeded(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entered SUCCEEDED state");
        }
        int attempt = context.getAttempt();
        String collectedDigits = context.getCollectedDigits();
        if (context.getIncludeEndInputKey()) {
            collectedDigits = collectedDigits + context.getEndInputKey();
        }
        OperationComplete operationComplete = new OperationComplete("pc", ReturnCode.SUCCESS.code());
        operationComplete.setParameter("na", String.valueOf(attempt));
        operationComplete.setParameter("dc", collectedDigits);
        this.mgcpEventSubject.notify(this.mgcpEventSubject, operationComplete);
    }

    @Override
    public void enterFailing(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entered FAILING state");
        }
        if (context.hasMoreAttempts()) {
            context.newAttempt();
            switch (event) {
                case RESTART: 
                case NO_DIGITS: 
                case REINPUT: {
                    this.fire((Object)event, context);
                    break;
                }
                default: {
                    this.fire((Object)PlayCollectEvent.RESTART, context);
                    break;
                }
            }
        } else {
            switch (event) {
                case NO_DIGITS: {
                    context.setReturnCode(ReturnCode.NO_DIGITS.code());
                    break;
                }
                case PATTERN_MISMATCH: {
                    context.setReturnCode(ReturnCode.DIGIT_PATTERN_NOT_MATCHED.code());
                    break;
                }
                case RESTART: 
                case REINPUT: {
                    context.setReturnCode(ReturnCode.MAX_ATTEMPTS_EXCEEDED.code());
                    break;
                }
                default: {
                    context.setReturnCode(ReturnCode.UNSPECIFIED_FAILURE.code());
                }
            }
            Playlist prompt = context.getFailureAnnouncement();
            if (prompt.isEmpty()) {
                this.fire((Object)PlayCollectEvent.NO_PROMPT, context);
            } else {
                this.fire((Object)PlayCollectEvent.PROMPT, context);
            }
        }
    }

    @Override
    public void exitFailing(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exited FAILING state");
        }
    }

    @Override
    public void enterPlayingFailure(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entered PLAYING FAILURE state");
        }
        Playlist prompt = context.getFailureAnnouncement();
        String track = prompt.next();
        try {
            this.player.addListener(this.playerListener);
            this.playAnnouncement(track, 0L);
        }
        catch (TooManyListenersException e) {
            log.error((Object)"Too many player listeners", (Throwable)e);
            context.setReturnCode(ReturnCode.UNSPECIFIED_FAILURE.code());
            this.fire((Object)PlayCollectEvent.FAIL, context);
        }
    }

    @Override
    public void onPlayingFailure(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        Playlist prompt;
        String track;
        if (log.isTraceEnabled()) {
            log.trace((Object)"On PLAYING FAILURE state");
        }
        if ((track = (prompt = context.getFailureAnnouncement()).next()).isEmpty()) {
            this.fire((Object)PlayCollectEvent.END_PROMPT, context);
        } else {
            this.playAnnouncement(track, 1000L);
        }
    }

    @Override
    public void exitPlayingFailure(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exited PLAYING FAILURE state");
        }
        this.player.removeListener(this.playerListener);
        this.player.deactivate();
    }

    @Override
    public void enterFailed(PlayCollectState from, PlayCollectState to, PlayCollectEvent event, PlayCollectContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entered FAILED state");
        }
        OperationFailed operationFailed = new OperationFailed("pc", context.getReturnCode());
        this.mgcpEventSubject.notify(this.mgcpEventSubject, operationFailed);
    }

    private final class DetectorTimer
    implements Runnable {
        private final long timestamp = System.currentTimeMillis();
        private final PlayCollectContext context;

        public DetectorTimer(PlayCollectContext context) {
            this.context = context;
        }

        @Override
        public void run() {
            if (this.context.getLastCollectedDigitOn() <= this.timestamp) {
                if (PlayCollectState.PLAY_COLLECT.equals(PlayCollectFsmImpl.this.getCurrentState())) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Timing out collect operation! " + this.context.getLastCollectedDigitOn() + " <= " + this.timestamp));
                    }
                    PlayCollectFsmImpl.this.fire((Object)PlayCollectEvent.TIMEOUT, this.context);
                }
            } else if (log.isTraceEnabled()) {
                log.trace((Object)"Aborting timeout operation because a tone has been received in the meantime.");
            }
        }
    }
}

