/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.pkg.au.pr;

import com.google.common.base.Optional;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Map;
import org.restcomm.media.control.mgcp.pkg.au.Playlist;
import org.restcomm.media.control.mgcp.pkg.au.SignalParameters;

public class PlayRecordContext {
    private final Map<String, String> parameters;
    private final Playlist initialPrompt;
    private final Playlist reprompt;
    private final Playlist noSpeechReprompt;
    private final Playlist failureAnnouncement;
    private final Playlist successAnnouncement;
    private char tone;
    private int attempt;
    private int returnCode;
    private boolean speechDetected;

    public PlayRecordContext(Map<String, String> parameters) {
        this.parameters = parameters;
        this.initialPrompt = new Playlist(this.getInitialPromptSegments(), 1);
        this.reprompt = new Playlist(this.getRepromptSegments(), 1);
        this.noSpeechReprompt = new Playlist(this.getNoSpeechRepromptSegments(), 1);
        this.failureAnnouncement = new Playlist(this.getFailureAnnouncementSegments(), 1);
        this.successAnnouncement = new Playlist(this.getSuccessAnnouncementSegments(), 1);
        this.returnCode = 0;
        this.attempt = 1;
        this.tone = (char)32;
        this.speechDetected = false;
    }

    private String getParameter(String name) {
        return this.parameters.get(name);
    }

    private String[] getInitialPromptSegments() {
        String value = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.INITIAL_PROMPT.symbol())).or((Object)"");
        return value.isEmpty() ? new String[]{} : value.split(",");
    }

    public Playlist getInitialPrompt() {
        return this.initialPrompt;
    }

    private String[] getRepromptSegments() {
        String segments = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.REPROMPT.symbol())).or((Object)"");
        return segments.isEmpty() ? this.getInitialPromptSegments() : segments.split(",");
    }

    public Playlist getReprompt() {
        return this.reprompt;
    }

    private String[] getNoSpeechRepromptSegments() {
        String segments = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.NO_SPEECH_REPROMTP.symbol())).or((Object)"");
        return segments.isEmpty() ? this.getRepromptSegments() : segments.split(",");
    }

    public Playlist getNoSpeechReprompt() {
        return this.noSpeechReprompt;
    }

    private String[] getFailureAnnouncementSegments() {
        String value = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.FAILURE_ANNOUNCEMENT.symbol())).or((Object)"");
        return value.isEmpty() ? new String[]{} : value.split(",");
    }

    public Playlist getFailureAnnouncement() {
        return this.failureAnnouncement;
    }

    public boolean hasFailureAnnouncement() {
        return !this.failureAnnouncement.isEmpty();
    }

    private String[] getSuccessAnnouncementSegments() {
        String value = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.SUCCESS_ANNOUNCEMENT.symbol())).or((Object)"");
        return value.isEmpty() ? new String[]{} : value.split(",");
    }

    public Playlist getSuccessAnnouncement() {
        return this.successAnnouncement;
    }

    public boolean hasSuccessAnnouncement() {
        return !this.successAnnouncement.isEmpty();
    }

    public String getRecordId() {
        return this.getParameter(SignalParameters.RECORD_ID.symbol());
    }

    public boolean hasRecording() {
        return Files.exists(Paths.get(this.getRecordId(), new String[0]), new LinkOption[0]);
    }

    public boolean getNonInterruptibleAudio() {
        String value = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.NON_INTERRUPTIBLE_PLAY.symbol())).or((Object)"false");
        return Boolean.parseBoolean(value);
    }

    public boolean getClearDigitBuffer() {
        String value = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.CLEAR_DIGIT_BUFFER.symbol())).or((Object)"false");
        return Boolean.parseBoolean(value);
    }

    public int getPreSpeechTimer() {
        String value = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.PRE_SPEECH_TIMER.symbol())).or((Object)"30");
        return Integer.parseInt(value) * 100;
    }

    public int getPostSpeechTimer() {
        String value = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.POST_SPEECH_TIMER.symbol())).or((Object)"20");
        return Integer.parseInt(value) * 100;
    }

    public int getTotalRecordingLengthTimer() {
        String value = this.getParameter(SignalParameters.TOTAL_RECORDING_LENGTH_TIMER.symbol());
        return Integer.parseInt(value) * 100;
    }

    public char getRestartKey() {
        String value = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.RESTART_KEY.symbol())).or((Object)"");
        return value.isEmpty() ? (char)' ' : value.charAt(0);
    }

    public char getReinputKey() {
        String value = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.REINPUT_KEY.symbol())).or((Object)"");
        return value.isEmpty() ? (char)' ' : value.charAt(0);
    }

    public char getReturnKey() {
        String value = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.RETURN_KEY.symbol())).or((Object)"");
        return value.isEmpty() ? (char)' ' : value.charAt(0);
    }

    public char getPositionKey() {
        String value = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.POSITION_KEY.symbol())).or((Object)"");
        return value.isEmpty() ? (char)' ' : value.charAt(0);
    }

    public char getStopKey() {
        String value = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.STOP_KEY.symbol())).or((Object)"");
        return value.isEmpty() ? (char)' ' : value.charAt(0);
    }

    public char getEndInputKey() {
        String value = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.END_INPUT_KEY.symbol())).or((Object)"");
        return value.isEmpty() ? (char)'#' : value.charAt(0);
    }

    public int getNumberOfAttempts() {
        String value = (String)Optional.fromNullable((Object)this.getParameter(SignalParameters.NUMBER_OF_ATTEMPTS.symbol())).or((Object)"1");
        return Integer.parseInt(value);
    }

    public char getTone() {
        return this.tone;
    }

    public void setTone(char tone) {
        this.tone = tone;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public boolean hasMoreAttempts() {
        return this.attempt < this.getNumberOfAttempts();
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    protected void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    public boolean isSpeechDetected() {
        return this.speechDetected;
    }

    public void setSpeechDetected(boolean speechDetected) {
        this.speechDetected = speechDetected;
    }

    protected void newAttempt() {
        ++this.attempt;
        this.initialPrompt.rewind();
        this.reprompt.rewind();
        this.noSpeechReprompt.rewind();
        this.successAnnouncement.rewind();
        this.failureAnnouncement.rewind();
        this.tone = (char)32;
        this.speechDetected = false;
    }
}

