/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.pkg.r.rto;

import java.util.regex.Pattern;
import org.restcomm.media.control.mgcp.exception.MgcpParseException;
import org.restcomm.media.control.mgcp.pkg.r.rto.RtpTimeoutEvent;
import org.restcomm.media.control.mgcp.pkg.r.rto.RtpTimeoutStartTime;

public class RtpTimeoutEventParser {
    private static final String TIMEOUT_REGEX = "\\d+";
    private static final Pattern TIMEOUT_PATTERN = Pattern.compile("\\d+");
    private static final String START_TIME_REGEX = "st=\\w{2}";
    private static final Pattern START_TIME_PATTERN = Pattern.compile("st=\\w{2}");

    public static RtpTimeoutEvent parse(int connectionId, String ... parameters) throws MgcpParseException {
        int timeout = 0;
        RtpTimeoutStartTime when = RtpTimeoutStartTime.IMMEDIATE;
        try {
            for (String parameter : parameters) {
                int indexOfEqual;
                if (TIMEOUT_PATTERN.matcher(parameter).matches()) {
                    timeout = Integer.parseInt(parameter);
                    continue;
                }
                if (!START_TIME_PATTERN.matcher(parameter).matches() || (when = RtpTimeoutStartTime.fromSymbol(parameter.substring((indexOfEqual = parameter.indexOf("=")) + 1))) != null) continue;
                throw new IllegalArgumentException("Unknown R/rto Start Time parameter: " + parameter);
            }
            if (timeout <= 0) {
                throw new IllegalArgumentException("R/rto timeout parameter must be a positive value.");
            }
        }
        catch (Exception e) {
            throw new MgcpParseException("Could not parse parameters RTP Timeout event.", e);
        }
        return new RtpTimeoutEvent(connectionId, timeout, when);
    }
}

