/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.control.mgcp.util.collections;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.restcomm.media.control.mgcp.util.collections.ValueTransformers;

public class Parameters<K>
implements Cloneable {
    private final Map<K, String> parameters;

    public Parameters() {
        this.parameters = new HashMap<K, String>(10);
    }

    private Parameters(Map<K, String> parameters) {
        this.parameters = parameters;
    }

    private String get(K key) {
        return this.parameters.get(key);
    }

    private <V> Optional<V> get(K key, Function<String, V> transformer) {
        return Optional.fromNullable((Object)this.get(key)).transform(transformer);
    }

    public void put(K key, String value) {
        this.parameters.put(key, value);
    }

    public String remove(K key) {
        return this.parameters.remove(key);
    }

    public boolean containsKey(K key) {
        return this.parameters.containsKey(key);
    }

    public Optional<String> getString(K key) {
        return Optional.fromNullable((Object)this.get(key));
    }

    public Optional<Integer> getInteger(K key) {
        return this.get(key, ValueTransformers.STRING_TO_INTEGER);
    }

    public Optional<Integer> getIntegerBase16(K key) {
        return this.get(key, ValueTransformers.STRING_TO_INTEGER_BASE16);
    }

    public Optional<Long> getLong(K key) {
        return this.get(key, ValueTransformers.STRING_TO_LONG);
    }

    public Optional<Boolean> getBoolean(K key) {
        return this.get(key, ValueTransformers.STRING_TO_BOOLEAN);
    }

    public void clear() {
        this.parameters.clear();
    }

    public Set<K> keySet() {
        return this.parameters.keySet();
    }

    public int size() {
        return this.parameters.size();
    }

    public Parameters<K> clone() {
        return new Parameters<K>(new HashMap<K, String>(this.parameters));
    }
}

