/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.core.configuration;

public class ResourcesConfiguration {
    public static final int DTMF_DETECTOR_DBI = -35;
    public static final int DTMF_DETECTOR_TONE_DURATION = 100;
    public static final int DTMF_DETECTOR_TONE_INTERVAL = 400;
    public static final int DTMF_GENERATOR_TONE_VOLUME = -20;
    public static final int DTMF_GENERATOR_TONE_DURATION = 80;
    public static final int PLAYER_CACHE_SIZE = 0;
    public static final boolean PLAYER_CACHE_ENABLED = false;
    private int dtmfDetectorDbi = -35;
    private int dtmfDetectorToneDuration = 100;
    private int dtmfGeneratorToneVolume = -20;
    private int dtmfGeneratorToneDuration = 80;
    private int dtmfDetectorToneInterval = 400;
    private int playerCacheSize = 0;

    public int getDtmfDetectorDbi() {
        return this.dtmfDetectorDbi;
    }

    public void setDtmfDetectorDbi(int dtmfDetectorDbi) {
        if (dtmfDetectorDbi > 0 || dtmfDetectorDbi < -36) {
            throw new IllegalArgumentException("DTMF Detector Dbi must be negative and greater than -36");
        }
        this.dtmfDetectorDbi = dtmfDetectorDbi;
    }

    public int getDtmfDetectorToneDuration() {
        return this.dtmfDetectorToneDuration;
    }

    public void setDtmfDetectorToneDuration(int dtmfDetectorToneDuration) {
        if (dtmfDetectorToneDuration < 0) {
            throw new IllegalArgumentException("DTMF Detector Tone Duration cannot be negative");
        }
        this.dtmfDetectorToneDuration = dtmfDetectorToneDuration;
    }

    public int getDtmfDetectorToneInterval() {
        return this.dtmfDetectorToneInterval;
    }

    public void setDtmfDetectorToneInterval(int dtmfDetectorToneInterval) {
        if (dtmfDetectorToneInterval < 0) {
            throw new IllegalArgumentException("DTMF Detector Tone Interval cannot be negative");
        }
        this.dtmfDetectorToneInterval = dtmfDetectorToneInterval;
    }

    public int getDtmfGeneratorToneVolume() {
        return this.dtmfGeneratorToneVolume;
    }

    public void setDtmfGeneratorToneVolume(int dtmfGeneratorToneVolume) {
        if (dtmfGeneratorToneVolume > 0) {
            throw new IllegalArgumentException("DTMF Generator Tone Volume cannot be positive");
        }
        this.dtmfGeneratorToneVolume = dtmfGeneratorToneVolume;
    }

    public int getDtmfGeneratorToneDuration() {
        return this.dtmfGeneratorToneDuration;
    }

    public void setDtmfGeneratorToneDuration(int dtmfGeneratorToneDuration) {
        if (dtmfGeneratorToneDuration < 0) {
            throw new IllegalArgumentException("DTMF Generator Tone Duration cannot be negative");
        }
        this.dtmfGeneratorToneDuration = dtmfGeneratorToneDuration;
    }

    public void setPlayerCache(boolean playerCacheEnabled, int playerCacheSize) {
        if (!playerCacheEnabled) {
            this.playerCacheSize = 0;
            return;
        }
        if (playerCacheSize <= 0) {
            throw new IllegalArgumentException("Player cache size cannot be negative");
        }
        this.playerCacheSize = playerCacheSize;
    }

    public int getPlayerCacheSize() {
        return this.playerCacheSize;
    }

    public boolean getPlayerCacheEnabled() {
        return this.playerCacheSize != 0;
    }
}

