/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.core.configuration;

import org.restcomm.media.codec.g711.alaw.Encoder;
import org.restcomm.media.codec.ilbc.Decoder;

public enum CodecType {
    PCMU(0, "pcmu", org.restcomm.media.codec.g711.ulaw.Encoder.class.getName(), org.restcomm.media.codec.g711.ulaw.Decoder.class.getName()),
    PCMA(8, "pcma", Encoder.class.getName(), org.restcomm.media.codec.g711.alaw.Decoder.class.getName()),
    GSM(3, "gsm", org.restcomm.media.codec.gsm.Encoder.class.getName(), org.restcomm.media.codec.gsm.Decoder.class.getName()),
    L16(97, "l16", org.restcomm.media.codec.l16.Encoder.class.getName(), org.restcomm.media.codec.l16.Decoder.class.getName()),
    G729(18, "g729", org.restcomm.media.codec.g729.Encoder.class.getName(), org.restcomm.media.codec.g729.Decoder.class.getName()),
    ILBC(102, "ilbc", org.restcomm.media.codec.ilbc.Encoder.class.getName(), Decoder.class.getName()),
    DTMF(101, "telephone-event", "", "");

    private final int payloadType;
    private final String name;
    private final String encoder;
    private final String decoder;

    private CodecType(int payloadType, String name, String encoder, String decoder) {
        this.payloadType = payloadType;
        this.name = name;
        this.encoder = encoder;
        this.decoder = decoder;
    }

    public int getPayloadType() {
        return this.payloadType;
    }

    public String getName() {
        return this.name;
    }

    public String getEncoder() {
        return this.encoder;
    }

    public String getDecoder() {
        return this.decoder;
    }

    public static final CodecType fromName(String name) {
        if (name != null && !name.isEmpty()) {
            for (CodecType codec : CodecType.values()) {
                if (!codec.name.equalsIgnoreCase(name)) continue;
                return codec;
            }
        }
        return null;
    }
}

