/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.core.configuration;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class MediaConfiguration {
    public static final int MAX_DURATION = 14400;
    public static final int TIMEOUT = 0;
    public static final int LOW_PORT = 64534;
    public static final int HIGH_PORT = 65534;
    public static final int JITTER_BUFFER_SIZE = 50;
    private int maxDuration = 14400;
    private int timeout = 0;
    private int lowPort = 64534;
    private int highPort = 65534;
    private int jitterBufferSize = 50;
    private final Set<String> codecs = new HashSet<String>(5);

    public int getMaxDuration() {
        return this.maxDuration;
    }

    public void setMaxDuration(int maxDuration) {
        this.maxDuration = maxDuration;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("Media timeout cannot be negative.");
        }
        this.timeout = timeout;
    }

    public int getLowPort() {
        return this.lowPort;
    }

    public void setLowPort(int lowPort) {
        if (lowPort < 0 || lowPort > 65534) {
            throw new IllegalArgumentException("Lowest media port must be positive and lower than 65535");
        }
        if (lowPort > this.highPort) {
            throw new IllegalArgumentException("Lowest media port cannot be greater than highest port (" + this.highPort + ")");
        }
        this.lowPort = lowPort;
    }

    public int getHighPort() {
        return this.highPort;
    }

    public void setHighPort(int highPort) {
        if (highPort < 0 || highPort > 65534) {
            throw new IllegalArgumentException("Highest media port must be positive and lower than 65535");
        }
        if (highPort < this.lowPort) {
            throw new IllegalArgumentException("Highest media port cannot be greater than lowest port (" + this.lowPort + ")");
        }
        this.highPort = highPort;
    }

    public int getJitterBufferSize() {
        return this.jitterBufferSize;
    }

    public void setJitterBufferSize(int jitterBufferSize) {
        if (jitterBufferSize < 0) {
            throw new IllegalArgumentException("Jitter Buffer size must be positive.");
        }
        this.jitterBufferSize = jitterBufferSize;
    }

    public void addCodec(String codec) {
        if (codec == null || codec.isEmpty()) {
            throw new IllegalArgumentException("Codec cannot be empty.");
        }
        this.codecs.add(codec.toLowerCase());
    }

    public Iterator<String> getCodecs() {
        return this.codecs.iterator();
    }

    public boolean hasCodec(String codec) {
        if (codec == null || codec.isEmpty()) {
            return false;
        }
        return this.codecs.contains(codec.toLowerCase());
    }

    public int countCodecs() {
        return this.codecs.size();
    }

    public void removeCodec(String codec) {
        this.codecs.remove(codec);
    }

    public void removeAllCodecs() {
        this.codecs.clear();
    }
}

