/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.component.audio;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.restcomm.media.component.audio.AudioComponent;
import org.restcomm.media.concurrent.ConcurrentMap;
import org.restcomm.media.scheduler.PriorityQueueScheduler;
import org.restcomm.media.scheduler.Task;
import org.restcomm.media.spi.format.AudioFormat;
import org.restcomm.media.spi.format.FormatFactory;

public class AudioSplitter {
    private final PriorityQueueScheduler scheduler;
    private static final AudioFormat FORMAT = FormatFactory.createAudioFormat((String)"LINEAR", (int)8000, (int)16, (int)1);
    private static final long PERIOD = 20000000L;
    private static final int PACKET_SIZE = 20 * FORMAT.getSampleRate() / 1000 * FORMAT.getSampleSize() / 8;
    private final ConcurrentMap<AudioComponent> insideComponents;
    private final ConcurrentMap<AudioComponent> outsideComponents;
    private final InsideMixTask insideMixer;
    private final OutsideMixTask outsideMixer;
    private final AtomicBoolean started;
    private final AtomicLong mixCount;
    private double gain = 1.0;

    public AudioSplitter(PriorityQueueScheduler scheduler) {
        this.scheduler = scheduler;
        this.insideMixer = new InsideMixTask();
        this.outsideMixer = new OutsideMixTask();
        this.insideComponents = new ConcurrentMap();
        this.outsideComponents = new ConcurrentMap();
        this.started = new AtomicBoolean(false);
        this.mixCount = new AtomicLong(0L);
    }

    public void addInsideComponent(AudioComponent component) {
        this.insideComponents.put((Object)component.getComponentId(), (Object)component);
    }

    public void addOutsideComponent(AudioComponent component) {
        this.outsideComponents.put((Object)component.getComponentId(), (Object)component);
    }

    protected int getPacketSize() {
        return PACKET_SIZE;
    }

    public void releaseInsideComponent(AudioComponent component) {
        this.insideComponents.remove((Object)component.getComponentId());
    }

    public void releaseOutsideComponent(AudioComponent component) {
        this.outsideComponents.remove((Object)component.getComponentId());
    }

    public void setGain(double gain) {
        this.gain = gain > 0.0 ? gain * 1.26 : (gain == 0.0 ? 1.0 : 1.0 / (gain * 1.26));
    }

    public void start() {
        if (!this.started.get()) {
            this.mixCount.set(0L);
            this.started.set(true);
            this.scheduler.submit((Task)this.insideMixer, PriorityQueueScheduler.MIXER_MIX_QUEUE);
            this.scheduler.submit((Task)this.outsideMixer, PriorityQueueScheduler.MIXER_MIX_QUEUE);
        }
    }

    public void stop() {
        if (this.started.get()) {
            this.started.set(false);
            this.insideMixer.cancel();
            this.outsideMixer.cancel();
        }
    }

    static /* synthetic */ int access$000() {
        return PACKET_SIZE;
    }

    private class OutsideMixTask
    extends Task {
        private final int[] total = new int[AudioSplitter.access$000() / 2];

        public int getQueueNumber() {
            return PriorityQueueScheduler.MIXER_MIX_QUEUE;
        }

        public long perform() {
            int i;
            boolean first = true;
            Iterator outsideRIterator = AudioSplitter.this.outsideComponents.valuesIterator();
            while (outsideRIterator.hasNext()) {
                AudioComponent component = (AudioComponent)outsideRIterator.next();
                component.perform();
                int[] current = component.getData();
                if (current == null) continue;
                if (first) {
                    System.arraycopy(current, 0, this.total, 0, this.total.length);
                    first = false;
                    continue;
                }
                for (i = 0; i < this.total.length; ++i) {
                    int n = i;
                    this.total[n] = this.total[n] + current[i];
                }
            }
            if (first) {
                AudioSplitter.this.scheduler.submit((Task)this, PriorityQueueScheduler.MIXER_MIX_QUEUE);
                AudioSplitter.this.mixCount.incrementAndGet();
                return 0L;
            }
            int minValue = 0;
            int maxValue = 0;
            for (i = 0; i < this.total.length; ++i) {
                if (this.total[i] > maxValue) {
                    maxValue = this.total[i];
                    continue;
                }
                if (this.total[i] >= minValue) continue;
                minValue = this.total[i];
            }
            if ((minValue = 0 - minValue) > maxValue) {
                maxValue = minValue;
            }
            double currGain = AudioSplitter.this.gain;
            if (maxValue > Short.MAX_VALUE) {
                currGain = currGain * 32767.0 / (double)maxValue;
            }
            for (int i2 = 0; i2 < this.total.length; ++i2) {
                this.total[i2] = (short)Math.round((double)this.total[i2] * currGain);
            }
            Iterator insideSIterator = AudioSplitter.this.insideComponents.valuesIterator();
            while (insideSIterator.hasNext()) {
                AudioComponent component = (AudioComponent)insideSIterator.next();
                component.offer(this.total);
            }
            AudioSplitter.this.scheduler.submit((Task)this, PriorityQueueScheduler.MIXER_MIX_QUEUE);
            AudioSplitter.this.mixCount.incrementAndGet();
            return 0L;
        }
    }

    private class InsideMixTask
    extends Task {
        private final int[] total = new int[AudioSplitter.access$000() / 2];

        public int getQueueNumber() {
            return PriorityQueueScheduler.MIXER_MIX_QUEUE;
        }

        public long perform() {
            int i;
            boolean first = true;
            Iterator insideRIterator = AudioSplitter.this.insideComponents.valuesIterator();
            while (insideRIterator.hasNext()) {
                AudioComponent component = (AudioComponent)insideRIterator.next();
                component.perform();
                int[] current = component.getData();
                if (current == null) continue;
                if (first) {
                    System.arraycopy(current, 0, this.total, 0, this.total.length);
                    first = false;
                    continue;
                }
                for (i = 0; i < this.total.length; ++i) {
                    int n = i;
                    this.total[n] = this.total[n] + current[i];
                }
            }
            if (first) {
                AudioSplitter.this.scheduler.submit((Task)this, PriorityQueueScheduler.MIXER_MIX_QUEUE);
                AudioSplitter.this.mixCount.incrementAndGet();
                return 0L;
            }
            int minValue = 0;
            int maxValue = 0;
            for (i = 0; i < this.total.length; ++i) {
                if (this.total[i] > maxValue) {
                    maxValue = this.total[i];
                    continue;
                }
                if (this.total[i] >= minValue) continue;
                minValue = this.total[i];
            }
            if (minValue > 0) {
                minValue = 0 - minValue;
            }
            if (minValue > maxValue) {
                maxValue = minValue;
            }
            double currGain = AudioSplitter.this.gain;
            if (maxValue > Short.MAX_VALUE) {
                currGain = currGain * 32767.0 / (double)maxValue;
            }
            for (int i2 = 0; i2 < this.total.length; ++i2) {
                this.total[i2] = (short)Math.round((double)this.total[i2] * currGain);
            }
            Iterator outsideSIterator = AudioSplitter.this.outsideComponents.valuesIterator();
            while (outsideSIterator.hasNext()) {
                AudioComponent component = (AudioComponent)outsideSIterator.next();
                component.offer(this.total);
            }
            AudioSplitter.this.scheduler.submit((Task)this, PriorityQueueScheduler.MIXER_MIX_QUEUE);
            AudioSplitter.this.mixCount.incrementAndGet();
            return 0L;
        }
    }
}

