/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.component.dsp;

import org.restcomm.media.spi.dsp.Codec;
import org.restcomm.media.spi.dsp.Processor;
import org.restcomm.media.spi.format.Format;
import org.restcomm.media.spi.memory.Frame;

public class Dsp
implements Processor {
    private Codec codec;
    private Codec[] codecs;
    private Format sourceFormat;
    private Format destinationFormat;

    protected Dsp(Codec[] codecs) {
        this.codecs = codecs;
    }

    public Codec[] getCodecs() {
        return this.codecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Frame process(Frame frame, Format source, Format destination) {
        if (source == null || destination == null) {
            return frame;
        }
        if (source.matches(destination)) {
            return frame;
        }
        if (this.sourceFormat != null && source.matches(this.sourceFormat) && this.destinationFormat != null && destination.matches(this.destinationFormat)) {
            if (this.codec != null) {
                try {
                    Frame frame2 = this.codec.process(frame);
                    return frame2;
                }
                finally {
                    frame.recycle();
                }
            }
            return frame;
        }
        if (this.codecs == null) {
            return frame;
        }
        for (int i = 0; i < this.codecs.length; ++i) {
            if (!this.codecs[i].getSupportedInputFormat().matches(source) || !this.codecs[i].getSupportedOutputFormat().matches(destination)) continue;
            this.codec = this.codecs[i];
            this.destinationFormat = destination;
            this.sourceFormat = source;
            break;
        }
        if (this.codec != null) {
            try {
                Frame frame3 = this.codec.process(frame);
                return frame3;
            }
            finally {
                frame.recycle();
            }
        }
        return frame;
    }
}

