/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.component.audio;

public class GoertzelFilter {
    private double[] hamming;
    private double rw;
    private double iw;

    public GoertzelFilter() {
    }

    public GoertzelFilter(int f, int N, double len) {
        this.hamming = new double[N];
        double o = Math.PI * 2 / (double)N;
        for (int i = 0; i < N; ++i) {
            this.hamming[i] = 0.54 - 0.46 * Math.cos(o * (double)i);
        }
        this.rw = 2.0 * Math.cos(o * len * (double)f);
        this.iw = Math.sin(o * len * (double)f);
    }

    public double getPower(double f, double[] signal, int offset, int len, double scale) {
        int N = len;
        int M = N + offset;
        double o = Math.PI * 2 / (double)N;
        for (int i = offset; i < M; ++i) {
            int n = i;
            signal[n] = signal[n] * (0.54 - 0.46 * Math.cos(o * (double)i));
        }
        double realW = 2.0 * Math.cos(o * scale * f);
        double imagW = Math.sin(o * scale * f);
        double d1 = 0.0;
        double d2 = 0.0;
        double y = 0.0;
        for (int n = offset; n < M; ++n) {
            y = signal[n] + realW * d1 - d2;
            d2 = d1;
            d1 = y;
        }
        double resultr = 0.5 * realW * d1 - d2;
        double resulti = imagW * d1;
        return Math.sqrt(resultr * resultr + resulti * resulti);
    }

    public double getPower(double[] signal, int offset) {
        int M = this.hamming.length + offset;
        for (int i = offset; i < M; ++i) {
            int n = i;
            signal[n] = signal[n] * this.hamming[i - offset];
        }
        double d1 = 0.0;
        double d2 = 0.0;
        double y = 0.0;
        for (int n = offset; n < M; ++n) {
            y = signal[n] + this.rw * d1 - d2;
            d2 = d1;
            d1 = y;
        }
        double resultr = 0.5 * this.rw * d1 - d2;
        double resulti = this.iw * d1;
        return Math.sqrt(resultr * resultr + resulti * resulti);
    }
}

