/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.component.oob;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.restcomm.media.component.oob.OOBInput;
import org.restcomm.media.component.oob.OOBOutput;
import org.restcomm.media.concurrent.ConcurrentMap;
import org.restcomm.media.spi.memory.Frame;

public class OOBComponent {
    private final int componentId;
    private final ConcurrentMap<OOBInput> inputs;
    private final ConcurrentMap<OOBOutput> outputs;
    private final AtomicBoolean shouldRead;
    private final AtomicBoolean shouldWrite;
    private Frame frame;

    public OOBComponent(int componentId) {
        this.componentId = componentId;
        this.inputs = new ConcurrentMap();
        this.outputs = new ConcurrentMap();
        this.shouldRead = new AtomicBoolean(false);
        this.shouldWrite = new AtomicBoolean(false);
    }

    public int getComponentId() {
        return this.componentId;
    }

    public void updateMode(boolean shouldRead, boolean shouldWrite) {
        this.shouldRead.set(shouldRead);
        this.shouldWrite.set(shouldWrite);
    }

    public void addInput(OOBInput input) {
        this.inputs.put((Object)input.getInputId(), (Object)input);
    }

    public void addOutput(OOBOutput output) {
        this.outputs.put((Object)output.getOutputId(), (Object)output);
    }

    public void remove(OOBInput input) {
        this.inputs.remove((Object)input.getInputId());
    }

    public void remove(OOBOutput output) {
        this.outputs.remove((Object)output.getOutputId());
    }

    public void perform() {
        this.frame = null;
        Iterator activeInputs = this.inputs.valuesIterator();
        while (activeInputs.hasNext()) {
            OOBInput input = (OOBInput)activeInputs.next();
            this.frame = input.poll();
            if (this.frame == null) continue;
            break;
        }
    }

    public Frame getData() {
        if (!this.shouldRead.get()) {
            if (this.frame != null) {
                this.frame.recycle();
            }
            return null;
        }
        return this.frame;
    }

    public void offer(Frame frame) {
        if (!this.shouldWrite.get()) {
            frame.recycle();
            return;
        }
        Iterator activeOutputs = this.outputs.valuesIterator();
        while (activeOutputs.hasNext()) {
            OOBOutput output = (OOBOutput)activeOutputs.next();
            if (!activeOutputs.hasNext()) {
                output.offer(frame);
            } else {
                output.offer(frame.clone());
            }
            output.wakeup();
        }
    }
}

