/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.component.oob;

import org.restcomm.media.component.AbstractSink;
import org.restcomm.media.component.AbstractSource;
import org.restcomm.media.concurrent.ConcurrentCyclicFIFO;
import org.restcomm.media.scheduler.PriorityQueueScheduler;
import org.restcomm.media.spi.memory.Frame;

public class OOBOutput
extends AbstractSource {
    private static final long serialVersionUID = -1350715959623627363L;
    private int outputId;
    private ConcurrentCyclicFIFO<Frame> buffer = new ConcurrentCyclicFIFO();

    public OOBOutput(PriorityQueueScheduler scheduler, int outputId) {
        super("compound.output", scheduler, PriorityQueueScheduler.OUTPUT_QUEUE);
        this.outputId = outputId;
    }

    public int getOutputId() {
        return this.outputId;
    }

    public void join(AbstractSink sink) {
        this.connect(sink);
    }

    public void unjoin() {
        this.disconnect();
    }

    @Override
    public Frame evolve(long timestamp) {
        return (Frame)this.buffer.poll();
    }

    @Override
    public void stop() {
        while (this.buffer.size() > 0) {
            ((Frame)this.buffer.poll()).recycle();
        }
        super.stop();
    }

    public void resetBuffer() {
        while (this.buffer.size() > 0) {
            ((Frame)this.buffer.poll()).recycle();
        }
    }

    public void offer(Frame frame) {
        if (this.buffer.size() > 1) {
            ((Frame)this.buffer.poll()).recycle();
        }
        this.buffer.offer((Object)frame);
    }
}

