/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.sdp.dtls.attributes.parser;

import java.util.regex.Pattern;
import org.restcomm.media.sdp.SdpException;
import org.restcomm.media.sdp.SdpParser;
import org.restcomm.media.sdp.dtls.attributes.FingerprintAttribute;

public class FingerprintAttributeParser
implements SdpParser<FingerprintAttribute> {
    private static final String REGEX = "^a=fingerprint:\\S+\\s(\\w+(:\\w+)+)$";
    private static final Pattern PATTERN = Pattern.compile("^a=fingerprint:\\S+\\s(\\w+(:\\w+)+)$");

    @Override
    public boolean canParse(String sdp) {
        if (sdp == null || sdp.isEmpty()) {
            return false;
        }
        return PATTERN.matcher(sdp.trim()).matches();
    }

    @Override
    public FingerprintAttribute parse(String sdp) throws SdpException {
        try {
            int separator = sdp.indexOf(":");
            if (separator == -1) {
                throw new IllegalArgumentException("No value found");
            }
            String[] values = sdp.trim().substring(separator + 1).split(" ");
            String hashFunction = values[0];
            String fingerprint = values[1];
            return new FingerprintAttribute(hashFunction, fingerprint);
        }
        catch (Exception e) {
            throw new SdpException("Could not parse SDP: " + sdp, e);
        }
    }

    @Override
    public void parse(FingerprintAttribute field, String sdp) throws SdpException {
        try {
            int separator = sdp.indexOf(":");
            if (separator == -1) {
                throw new IllegalArgumentException("No value found");
            }
            String[] values = sdp.trim().substring(separator + 1).split(" ");
            String hashFunction = values[0];
            String fingerprint = values[1];
            field.setHashFunction(hashFunction);
            field.setFingerprint(fingerprint);
        }
        catch (Exception e) {
            throw new SdpException("Could not parse SDP: " + sdp, e);
        }
    }
}

