/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.sdp.attributes.parser;

import java.util.regex.Pattern;
import org.restcomm.media.sdp.SdpException;
import org.restcomm.media.sdp.SdpParser;
import org.restcomm.media.sdp.attributes.PacketTimeAttribute;

public class PacketTimeAttributeParser
implements SdpParser<PacketTimeAttribute> {
    private static final String REGEX = "^a=ptime:\\d+$";
    private static final Pattern PATTERN = Pattern.compile("^a=ptime:\\d+$");

    @Override
    public boolean canParse(String sdp) {
        if (sdp == null || sdp.isEmpty()) {
            return false;
        }
        return PATTERN.matcher(sdp.trim()).matches();
    }

    @Override
    public PacketTimeAttribute parse(String sdp) throws SdpException {
        try {
            int separator = sdp.indexOf(":");
            if (separator == -1) {
                throw new IllegalArgumentException("No value found");
            }
            int value = Integer.parseInt(sdp.trim().substring(separator + 1));
            return new PacketTimeAttribute(value);
        }
        catch (Exception e) {
            throw new SdpException("Could not parse SDP: " + sdp, e);
        }
    }

    @Override
    public void parse(PacketTimeAttribute field, String sdp) throws SdpException {
        try {
            int separator = sdp.indexOf(":");
            if (separator == -1) {
                throw new IllegalArgumentException("No value found");
            }
            int value = Integer.parseInt(sdp.trim().substring(separator + 1));
            field.setTime(value);
        }
        catch (Exception e) {
            throw new SdpException("Could not parse SDP: " + sdp, e);
        }
    }
}

