/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.stun.messages.attributes.general;

import java.util.Arrays;
import org.restcomm.media.stun.StunException;
import org.restcomm.media.stun.messages.attributes.StunAttribute;

public class UsernameAttribute
extends StunAttribute {
    public static final String NAME = "USERNAME";
    private byte[] username = null;

    public UsernameAttribute() {
        super('\u0006');
    }

    public byte[] getUsername() {
        return this.username == null ? null : (byte[])this.username.clone();
    }

    public void setUsername(byte[] username) {
        if (username == null) {
            this.username = null;
        } else {
            this.username = new byte[username.length];
            System.arraycopy(username, 0, this.username, 0, username.length);
        }
    }

    @Override
    public char getDataLength() {
        if (this.username == null) {
            return '\u0000';
        }
        return (char)this.username.length;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof UsernameAttribute) || other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        UsernameAttribute att = (UsernameAttribute)other;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && Arrays.equals(att.username, this.username);
    }

    @Override
    public byte[] encode() {
        char type = this.getAttributeType();
        byte[] binValue = new byte[4 + this.getDataLength() + (4 - this.getDataLength() % 4) % 4];
        binValue[0] = (byte)(type >> 8);
        binValue[1] = (byte)(type & 0xFF);
        binValue[2] = (byte)(this.getDataLength() >> 8);
        binValue[3] = (byte)(this.getDataLength() & 0xFF);
        System.arraycopy(this.username, 0, binValue, 4, this.getDataLength());
        return binValue;
    }

    @Override
    protected void decodeAttributeBody(byte[] data, char offset, char length) throws StunException {
        this.username = new byte[length];
        System.arraycopy(data, offset, this.username, 0, length);
    }
}

