/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.stun.messages.attributes.general;

import org.restcomm.media.stun.StunException;
import org.restcomm.media.stun.messages.attributes.StunAttribute;
import org.restcomm.media.stun.messages.attributes.general.LifetimeAttribute;

public class MagicCookieAttribute
extends StunAttribute {
    public static final String NAME = "MAGIC-COOKIE";
    public static final char DATA_LENGTH = '\u0004';
    private int value = 1925598150;

    public MagicCookieAttribute() {
        super('\u000f');
    }

    @Override
    public char getDataLength() {
        return '\u0004';
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof LifetimeAttribute)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        MagicCookieAttribute att = (MagicCookieAttribute)other;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && att.value == this.value;
    }

    @Override
    public byte[] encode() {
        byte[] binValue = new byte[]{(byte)(this.getAttributeType() >> 8), (byte)(this.getAttributeType() & 0xFF), (byte)(this.getDataLength() >> 8), (byte)(this.getDataLength() & 0xFF), (byte)(this.value >> 24 & 0xFF), (byte)(this.value >> 16 & 0xFF), (byte)(this.value >> 8 & 0xFF), (byte)(this.value & 0xFF)};
        return binValue;
    }

    @Override
    protected void decodeAttributeBody(byte[] data, char offset, char length) throws StunException {
        if (length != '\u0004') {
            throw new StunException("Invalid length:" + length);
        }
        this.value = (data[0] << 24 & 0xFF000000) + (data[1] << 16 & 0xFF0000) + (data[2] << 8 & 0xFF00) + (data[3] & 0xFF);
    }
}

