/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.ice.network.nio;

import java.nio.channels.DatagramChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.restcomm.media.ice.network.nio.NioServer;
import org.restcomm.media.ice.network.nio.ScheduledEvent;

public class EventScheduler
implements Runnable {
    private List<ScheduledEvent> events = new ArrayList<ScheduledEvent>();
    private final NioServer server;
    private volatile boolean running;

    public EventScheduler(NioServer server) {
        this.server = server;
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(DatagramChannel channel, byte[] data, int dataLength) {
        byte[] dataCopy = Arrays.copyOf(data, dataLength);
        List<ScheduledEvent> list = this.events;
        synchronized (list) {
            ScheduledEvent event = new ScheduledEvent(this.server, channel, dataCopy);
            this.events.add(event);
            this.events.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        while (this.running && !this.hasWork()) {
            ScheduledEvent event;
            List<ScheduledEvent> list = this.events;
            synchronized (list) {
                while (this.events.isEmpty()) {
                    try {
                        this.events.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                event = this.events.remove(0);
            }
            event.launch();
        }
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasWork() {
        List<ScheduledEvent> list = this.events;
        synchronized (list) {
            return !this.events.isEmpty();
        }
    }

    public void stop() {
        this.running = false;
    }

    public void stopNow() {
        this.running = false;
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        List<ScheduledEvent> list = this.events;
        synchronized (list) {
            this.events.clear();
        }
    }
}

