/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.ice.harvest;

import java.net.InetAddress;
import java.nio.channels.Selector;
import java.util.HashMap;
import java.util.Map;
import org.restcomm.media.ice.CandidateType;
import org.restcomm.media.ice.FoundationsRegistry;
import org.restcomm.media.ice.IceMediaStream;
import org.restcomm.media.ice.harvest.CandidateHarvester;
import org.restcomm.media.ice.harvest.HarvestException;
import org.restcomm.media.ice.harvest.HostCandidateHarvester;
import org.restcomm.media.ice.harvest.NoCandidatesGatheredException;
import org.restcomm.media.ice.lite.LiteFoundationsRegistry;
import org.restcomm.media.network.deprecated.RtpPortManager;

public class HarvestManager {
    private final FoundationsRegistry foundations = new LiteFoundationsRegistry();
    private final Map<CandidateType, CandidateHarvester> harvesters = new HashMap<CandidateType, CandidateHarvester>(CandidateType.count());
    private InetAddress externalAddress;

    public HarvestManager() {
        this.harvesters.put(CandidateType.HOST, new HostCandidateHarvester(this.foundations));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addHarvester(CandidateHarvester harvester) {
        CandidateType candidateType = harvester.getCandidateType();
        boolean added = false;
        Map<CandidateType, CandidateHarvester> map = this.harvesters;
        synchronized (map) {
            if (!this.harvesters.containsKey((Object)candidateType)) {
                this.harvesters.put(candidateType, harvester);
                added = true;
            } else {
                added = false;
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CandidateHarvester removeHarvester(CandidateType type) {
        Map<CandidateType, CandidateHarvester> map = this.harvesters;
        synchronized (map) {
            return this.harvesters.remove((Object)type);
        }
    }

    public FoundationsRegistry getFoundationsRegistry() {
        return this.foundations;
    }

    public InetAddress getExternalAddress() {
        return this.externalAddress;
    }

    public void harvest(IceMediaStream mediaStream, RtpPortManager portManager, Selector selector) throws HarvestException, NoCandidatesGatheredException {
        CandidateHarvester relayHarvester;
        CandidateHarvester hostHarvester = this.harvesters.get((Object)CandidateType.HOST);
        if (hostHarvester == null) {
            throw new HarvestException("No HOST harvester registered!");
        }
        hostHarvester.harvest(portManager, mediaStream, selector);
        CandidateHarvester srflxHarvester = this.harvesters.get((Object)CandidateType.SRFLX);
        if (srflxHarvester != null) {
            srflxHarvester.harvest(portManager, mediaStream, selector);
        }
        if ((relayHarvester = this.harvesters.get((Object)CandidateType.RELAY)) != null) {
            relayHarvester.harvest(portManager, mediaStream, selector);
        }
        if (!mediaStream.hasLocalRtpCandidates()) {
            throw new NoCandidatesGatheredException("No RTP candidates were gathered for " + mediaStream.getName() + " stream");
        }
        mediaStream.getRtpComponent().selectDefaultLocalCandidate();
        if (mediaStream.supportsRtcp() && !mediaStream.isRtcpMux()) {
            mediaStream.getRtcpComponent().selectDefaultLocalCandidate();
        }
    }
}

