/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.ice.network.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.restcomm.media.ice.network.ProtocolHandler;
import org.restcomm.media.ice.network.nio.EventScheduler;
import org.restcomm.media.ice.network.nio.OperationRequest;

public class NioServer
implements Runnable {
    private Logger logger = Logger.getLogger(NioServer.class);
    private static final int BUFFER_SIZE = 8192;
    private Selector selector;
    private ByteBuffer buffer;
    private EventScheduler scheduler;
    private List<OperationRequest> operationRequests;
    private Map<DatagramChannel, List<ByteBuffer>> pendingData;
    protected ProtocolHandler protocolHandler;
    private Thread schedulerThread;
    private Thread serverThread;
    private volatile boolean running;

    public NioServer(Selector selector) {
        this.selector = selector;
        this.buffer = ByteBuffer.allocate(8192);
        this.scheduler = new EventScheduler(this);
        this.operationRequests = new LinkedList<OperationRequest>();
        this.pendingData = new HashMap<DatagramChannel, List<ByteBuffer>>();
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        if (!this.running) {
            this.schedulerThread = new Thread(this.scheduler);
            this.serverThread = new Thread(this);
            this.running = true;
            this.schedulerThread.start();
            this.serverThread.start();
        }
    }

    public void stop() {
        this.running = false;
    }

    public void stopNow() {
        this.running = false;
        this.scheduler.stop();
    }

    private void cleanup() {
        if (this.selector.isOpen()) {
            try {
                this.selector.close();
            }
            catch (IOException e) {
                this.logger.error((Object)("Server did not stop in an elegant manner: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.logger.info((Object)"NIO Server started");
        while (this.running && this.selector.isOpen()) {
            try {
                List<OperationRequest> list = this.operationRequests;
                synchronized (list) {
                    Iterator<OperationRequest> changes = this.operationRequests.iterator();
                    while (changes.hasNext()) {
                        SelectionKey key;
                        OperationRequest request = changes.next();
                        if (2 == request.getRequestType() && (key = request.getChannel().keyFor(this.selector)) != null && key.isValid()) {
                            key.interestOps(request.getOperations());
                        }
                        changes.remove();
                    }
                }
                this.selector.select();
                Iterator<SelectionKey> selectedKeys = this.selector.selectedKeys().iterator();
                while (selectedKeys.hasNext()) {
                    SelectionKey key = selectedKeys.next();
                    selectedKeys.remove();
                    if (!key.isValid()) continue;
                    try {
                        if (key.isReadable()) {
                            this.read(key);
                            continue;
                        }
                        if (!key.isWritable()) continue;
                        this.write(key);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("Could not process packet: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.cleanup();
        this.logger.info((Object)"NIO Server stopped");
    }

    private List<ByteBuffer> registerChannel(DatagramChannel channel) {
        ArrayList<ByteBuffer> data = new ArrayList<ByteBuffer>();
        this.pendingData.put(channel, data);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(DatagramChannel channel, byte[] data) {
        List<OperationRequest> list = this.operationRequests;
        synchronized (list) {
            OperationRequest writeRequest = new OperationRequest(channel, 2, 4);
            this.operationRequests.add(writeRequest);
            Map<DatagramChannel, List<ByteBuffer>> map = this.pendingData;
            synchronized (map) {
                List<ByteBuffer> queue = this.pendingData.get(channel);
                if (queue == null) {
                    queue = this.registerChannel(channel);
                }
                queue.add(ByteBuffer.wrap(data));
            }
        }
        this.selector.wakeup();
    }

    private void read(SelectionKey key) throws IOException {
        byte[] data;
        byte[] response;
        DatagramChannel channel = (DatagramChannel)key.channel();
        this.buffer.clear();
        int dataLength = 0;
        try {
            SocketAddress remotePeer = channel.receive(this.buffer);
            if (!channel.isConnected() && remotePeer != null) {
                channel.connect(remotePeer);
            }
            dataLength = remotePeer == null ? -1 : this.buffer.position();
        }
        catch (IOException e) {
            dataLength = -1;
        }
        if (dataLength == -1) {
            channel.close();
            key.cancel();
            return;
        }
        if (this.protocolHandler != null && (response = this.protocolHandler.process(key, data = this.buffer.array(), dataLength)) != null) {
            this.scheduler.schedule(channel, response, response.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(SelectionKey key) throws IOException {
        DatagramChannel channel = (DatagramChannel)key.channel();
        Map<DatagramChannel, List<ByteBuffer>> map = this.pendingData;
        synchronized (map) {
            List<ByteBuffer> queue = this.pendingData.get(key.channel());
            while (!queue.isEmpty()) {
                ByteBuffer dataBuffer = queue.get(0);
                channel.send(dataBuffer, channel.getRemoteAddress());
                channel.write(dataBuffer);
                if (dataBuffer.remaining() > 0) break;
                queue.remove(0);
            }
            key.interestOps(1);
        }
    }
}

