/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.ice;

import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Selector;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.restcomm.media.ice.CandidatePair;
import org.restcomm.media.ice.CandidateType;
import org.restcomm.media.ice.IceAuthenticator;
import org.restcomm.media.ice.IceComponent;
import org.restcomm.media.ice.IceMediaStream;
import org.restcomm.media.ice.LocalCandidateWrapper;
import org.restcomm.media.ice.events.IceEventListener;
import org.restcomm.media.ice.events.SelectedCandidatesEvent;
import org.restcomm.media.ice.harvest.ExternalCandidateHarvester;
import org.restcomm.media.ice.harvest.HarvestException;
import org.restcomm.media.ice.harvest.HarvestManager;
import org.restcomm.media.ice.harvest.NoCandidatesGatheredException;
import org.restcomm.media.ice.network.stun.ConnectivityCheckServer;
import org.restcomm.media.network.deprecated.RtpPortManager;

public abstract class IceAgent
implements IceAuthenticator {
    private static final Logger logger = Logger.getLogger(IceAgent.class);
    private final Map<String, IceMediaStream> mediaStreams = new LinkedHashMap<String, IceMediaStream>(5);
    private final HarvestManager harvestManager = new HarvestManager();
    private final SecureRandom random;
    protected String ufrag = "";
    protected String password = "";
    protected Selector selector;
    protected ConnectivityCheckServer connectivityCheckServer;
    private volatile int selectedPairs = 0;
    private volatile int maxSelectedPairs = 0;
    protected volatile boolean running = false;
    protected final List<IceEventListener> iceListeners = new ArrayList<IceEventListener>(5);
    private InetAddress externalAddress;

    protected IceAgent() {
        this.random = new SecureRandom();
    }

    public void generateIceCredentials() {
        this.ufrag = new BigInteger(24, this.random).toString(32);
        this.password = new BigInteger(128, this.random).toString(32);
    }

    public abstract boolean isLite();

    public abstract boolean isControlling();

    public boolean isRunning() {
        return this.running;
    }

    public String getUfrag() {
        return this.ufrag;
    }

    public String getPassword() {
        return this.password;
    }

    public IceMediaStream addMediaStream(String streamName) {
        return this.addMediaStream(streamName, true);
    }

    public IceMediaStream addMediaStream(String streamName, boolean rtcp) {
        return this.addMediaStream(streamName, rtcp, false);
    }

    public IceMediaStream addMediaStream(String streamName, boolean rtcp, boolean rtcpMux) {
        if (!this.mediaStreams.containsKey(streamName)) {
            this.maxSelectedPairs += rtcp && !rtcpMux ? 2 : 1;
            return this.mediaStreams.put(streamName, new IceMediaStream(streamName, rtcp, rtcpMux));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IceMediaStream getMediaStream(String streamName) {
        IceMediaStream mediaStream;
        Map<String, IceMediaStream> map = this.mediaStreams;
        synchronized (map) {
            mediaStream = this.mediaStreams.get(streamName);
        }
        return mediaStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IceMediaStream> getMediaStreams() {
        ArrayList<IceMediaStream> copy;
        Map<String, IceMediaStream> map = this.mediaStreams;
        synchronized (map) {
            copy = new ArrayList<IceMediaStream>(this.mediaStreams.values());
        }
        return copy;
    }

    public void harvest(RtpPortManager portManager) throws HarvestException, NoCandidatesGatheredException {
        if (this.selector == null || !this.selector.isOpen()) {
            try {
                this.selector = Selector.open();
            }
            catch (IOException e) {
                throw new HarvestException("Could not initialize selector", e);
            }
        }
        for (IceMediaStream mediaStream : this.getMediaStreams()) {
            this.harvestManager.harvest(mediaStream, portManager, this.selector);
        }
    }

    public abstract void start();

    public abstract void stop();

    public boolean isSelectionFinished() {
        return this.maxSelectedPairs == this.selectedPairs;
    }

    public CandidatePair selectCandidatePair(DatagramChannel channel) {
        InetSocketAddress address = null;
        try {
            address = (InetSocketAddress)channel.getLocalAddress();
        }
        catch (IOException e) {
            logger.error((Object)"Candidate selection canceled: cannot get address of the candidate.", (Throwable)e);
            return null;
        }
        CandidatePair candidatePair = null;
        for (IceMediaStream mediaStream : this.getMediaStreams()) {
            IceComponent rtcpComponent;
            IceComponent rtpComponent = mediaStream.getRtpComponent();
            candidatePair = this.selectCandidatePair(rtpComponent, channel);
            if (candidatePair != null) {
                logger.info((Object)("Selected RTP candidate on address " + address.getHostString() + ":" + address.getPort()));
                break;
            }
            if (candidatePair != null || !mediaStream.supportsRtcp() || (candidatePair = this.selectCandidatePair(rtcpComponent = mediaStream.getRtcpComponent(), channel)) == null) continue;
            logger.info((Object)("Selected RTCP candidate on address " + address.getHostString() + ":" + address.getPort()));
            break;
        }
        if (candidatePair != null) {
            ++this.selectedPairs;
        }
        if (this.isSelectionFinished()) {
            logger.info((Object)"Selected all candidate pairs!");
            this.fireCandidatePairSelectedEvent();
        }
        return candidatePair;
    }

    private CandidatePair selectCandidatePair(IceComponent component, DatagramChannel channel) {
        for (LocalCandidateWrapper localCandidate : component.getLocalCandidates()) {
            if (!channel.equals(localCandidate.getChannel())) continue;
            return component.setCandidatePair(channel);
        }
        return null;
    }

    private CandidatePair getSelectedCandidate(String stream, int componentId) {
        IceMediaStream mediaStream = this.getMediaStream(stream);
        if (mediaStream != null) {
            IceComponent component = componentId == 1 ? mediaStream.getRtpComponent() : mediaStream.getRtcpComponent();
            return component.getSelectedCandidates();
        }
        return null;
    }

    public CandidatePair getSelectedRtpCandidate(String stream) {
        return this.getSelectedCandidate(stream, 1);
    }

    public CandidatePair getSelectedRtcpCandidate(String stream) {
        return this.getSelectedCandidate(stream, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIceListener(IceEventListener listener) {
        List<IceEventListener> list = this.iceListeners;
        synchronized (list) {
            if (!this.iceListeners.contains(listener)) {
                this.iceListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIceListener(IceEventListener listener) {
        List<IceEventListener> list = this.iceListeners;
        synchronized (list) {
            this.iceListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCandidatePairSelectedEvent() {
        ArrayList<IceEventListener> listeners;
        this.stop();
        List<IceEventListener> list = this.iceListeners;
        synchronized (list) {
            listeners = new ArrayList<IceEventListener>(this.iceListeners);
        }
        SelectedCandidatesEvent event = new SelectedCandidatesEvent(this);
        for (IceEventListener listener : listeners) {
            listener.onSelectedCandidates(event);
        }
    }

    @Override
    public byte[] getLocalKey(String ufrag) {
        if (this.isUserRegistered(ufrag) && this.password != null) {
            return this.password.getBytes();
        }
        return null;
    }

    @Override
    public byte[] getRemoteKey(String ufrag, String media) {
        IceMediaStream stream = this.getMediaStream(media);
        if (stream == null) {
            return null;
        }
        int colon = ufrag.indexOf(":");
        if (colon < 0 ? ufrag.equals(stream.getRemoteUfrag()) : ufrag.equals(this.getLocalUsername(stream)) && stream.getRemotePassword() != null) {
            return stream.getRemotePassword().getBytes();
        }
        return null;
    }

    private String getLocalUsername(IceMediaStream stream) {
        if (stream != null && stream.getRemotePassword() != null) {
            return this.ufrag + ":" + stream.getRemotePassword();
        }
        return null;
    }

    @Override
    public boolean isUserRegistered(String ufrag) {
        int colon = ufrag.indexOf(":");
        String result = colon < 0 ? ufrag : ufrag.substring(0, colon);
        return result.equals(this.ufrag);
    }

    public InetAddress getExternalAddress() {
        return this.externalAddress;
    }

    public void setExternalAddress(InetAddress externalAddress) {
        this.externalAddress = externalAddress;
        if (externalAddress != null) {
            this.harvestManager.addHarvester(new ExternalCandidateHarvester(this.harvestManager.getFoundationsRegistry(), externalAddress));
        } else {
            this.harvestManager.removeHarvester(CandidateType.SRFLX);
        }
    }

    @Override
    public boolean validateUsername(String username) {
        int colon = username.indexOf(":");
        if (colon == -1) {
            return false;
        }
        return username.substring(0, colon).equals(this.ufrag);
    }

    public void reset() {
        this.iceListeners.clear();
        this.mediaStreams.clear();
        this.maxSelectedPairs = 0;
        this.selectedPairs = 0;
        this.password = "";
        this.ufrag = "";
    }
}

