/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.ice;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.restcomm.media.ice.IceAuthenticator;

public class IceAuthenticatorImpl
implements IceAuthenticator {
    private final SecureRandom random = new SecureRandom();
    protected String ufrag = "";
    protected String password = "";
    protected String remoteUfrag = "";
    protected String remotePassword = "";
    private final StringBuilder builder = new StringBuilder();

    public String getUfrag() {
        return this.ufrag;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRemoteUfrag() {
        return this.remoteUfrag;
    }

    public void setRemoteUfrag(String remoteUfrag) {
        this.remoteUfrag = remoteUfrag;
    }

    public String getRemotePassword() {
        return this.remotePassword;
    }

    public void setRemotePassword(String remotePassword) {
        this.remotePassword = remotePassword;
    }

    public void generateIceCredentials() {
        this.ufrag = this.generateIceCredential(24, 4, 256);
        this.password = this.generateIceCredential(128, 22, 256);
    }

    private String generateIceCredential(int numBits, int min, int max) {
        this.builder.setLength(0);
        do {
            this.builder.append(new BigInteger(numBits, this.random).toString(32));
        } while (this.builder.length() < min);
        if (this.builder.length() > max) {
            this.builder.setLength(max);
        }
        return this.builder.toString();
    }

    @Override
    public byte[] getLocalKey(String ufrag) {
        if (this.isUserRegistered(ufrag) && this.password != null) {
            return this.password.getBytes();
        }
        return null;
    }

    @Override
    public byte[] getRemoteKey(String ufrag, String media) {
        int colon = ufrag.indexOf(":");
        if (colon < 0 ? ufrag.equals(this.remoteUfrag) : ufrag.equals(this.ufrag) && this.remotePassword != null) {
            return this.remotePassword.getBytes();
        }
        return null;
    }

    @Override
    public boolean isUserRegistered(String ufrag) {
        int colon = ufrag.indexOf(":");
        String result = colon < 0 ? ufrag : ufrag.substring(0, colon);
        return result.equals(this.ufrag);
    }

    @Override
    public boolean validateUsername(String username) {
        int colon = username.indexOf(":");
        if (colon == -1) {
            return false;
        }
        return username.substring(0, colon).equals(this.ufrag);
    }

    public void reset() {
        this.ufrag = "";
        this.password = "";
        this.remoteUfrag = "";
        this.remotePassword = "";
    }
}

