/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.ice.harvest;

import java.net.InetAddress;
import java.nio.channels.Selector;
import java.util.List;
import org.apache.log4j.Logger;
import org.restcomm.media.ice.CandidateType;
import org.restcomm.media.ice.FoundationsRegistry;
import org.restcomm.media.ice.HostCandidate;
import org.restcomm.media.ice.IceComponent;
import org.restcomm.media.ice.IceMediaStream;
import org.restcomm.media.ice.LocalCandidateWrapper;
import org.restcomm.media.ice.ServerReflexiveCandidate;
import org.restcomm.media.ice.harvest.CandidateHarvester;
import org.restcomm.media.ice.harvest.HarvestException;
import org.restcomm.media.network.deprecated.RtpPortManager;

public class ExternalCandidateHarvester
implements CandidateHarvester {
    Logger logger = Logger.getLogger(ExternalCandidateHarvester.class);
    private final FoundationsRegistry foundations;
    private final InetAddress externalAddress;

    public ExternalCandidateHarvester(FoundationsRegistry foundations, InetAddress externalAddress) {
        this.foundations = foundations;
        this.externalAddress = externalAddress;
    }

    @Override
    public void harvest(RtpPortManager portManager, IceMediaStream mediaStream, Selector selector) throws HarvestException {
        this.harvest(mediaStream.getRtpComponent());
        if (mediaStream.supportsRtcp() && !mediaStream.isRtcpMux()) {
            this.harvest(mediaStream.getRtcpComponent());
        }
    }

    private void harvest(IceComponent component) {
        List<LocalCandidateWrapper> rtpCandidates = component.getLocalCandidates();
        for (LocalCandidateWrapper candidateWrapper : rtpCandidates) {
            if (!(candidateWrapper.getCandidate() instanceof HostCandidate)) continue;
            HostCandidate hostCandidate = (HostCandidate)candidateWrapper.getCandidate();
            ServerReflexiveCandidate srflxCandidate = new ServerReflexiveCandidate(component, this.externalAddress, hostCandidate.getPort(), hostCandidate);
            this.foundations.assignFoundation(srflxCandidate);
            component.addLocalCandidate(new LocalCandidateWrapper(srflxCandidate, candidateWrapper.getChannel()));
        }
    }

    @Override
    public CandidateType getCandidateType() {
        return CandidateType.SRFLX;
    }
}

