/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.ice;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.restcomm.media.ice.IceAuthenticator;
import org.restcomm.media.ice.events.IceEventListener;
import org.restcomm.media.ice.events.SelectedCandidatesEvent;
import org.restcomm.media.network.deprecated.TransportAddress;
import org.restcomm.media.network.deprecated.channel.PacketHandler;
import org.restcomm.media.network.deprecated.channel.PacketHandlerException;
import org.restcomm.media.stun.StunException;
import org.restcomm.media.stun.messages.StunMessage;
import org.restcomm.media.stun.messages.StunMessageFactory;
import org.restcomm.media.stun.messages.StunRequest;
import org.restcomm.media.stun.messages.StunResponse;
import org.restcomm.media.stun.messages.attributes.StunAttribute;
import org.restcomm.media.stun.messages.attributes.StunAttributeFactory;
import org.restcomm.media.stun.messages.attributes.general.ErrorCodeAttribute;
import org.restcomm.media.stun.messages.attributes.general.MessageIntegrityAttribute;
import org.restcomm.media.stun.messages.attributes.general.UsernameAttribute;

public class IceHandler
implements PacketHandler {
    private static final Logger logger = Logger.getLogger(IceHandler.class);
    private int pipelinePriority = 1;
    private final short componentId;
    private IceAuthenticator authenticator;
    private final IceEventListener iceListener;
    private final AtomicBoolean candidateSelected;

    public IceHandler(short componentId, IceEventListener iceListener) {
        switch (componentId) {
            case 1: 
            case 2: {
                this.componentId = componentId;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid component ID: " + componentId);
            }
        }
        this.iceListener = iceListener;
        this.candidateSelected = new AtomicBoolean(false);
    }

    public short getComponentId() {
        return this.componentId;
    }

    public void setAuthenticator(IceAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    public int compareTo(PacketHandler o) {
        return o == null ? 1 : this.getPipelinePriority() - o.getPipelinePriority();
    }

    public boolean canHandle(byte[] packet) {
        return this.canHandle(packet, packet.length, 0);
    }

    public boolean canHandle(byte[] packet, int dataLength, int offset) {
        byte b0 = packet[offset];
        int b0Int = b0 & 0xFF;
        if (b0Int < 2 && dataLength >= 20) {
            boolean firstBitsValid = (b0 & 0xC0) == 0;
            boolean hasMagicCookie = packet[offset + 4] == StunMessage.MAGIC_COOKIE[0] && packet[offset + 5] == StunMessage.MAGIC_COOKIE[1] && packet[offset + 6] == StunMessage.MAGIC_COOKIE[2] && packet[offset + 7] == StunMessage.MAGIC_COOKIE[3];
            return firstBitsValid && hasMagicCookie;
        }
        return false;
    }

    public byte[] handle(byte[] packet, InetSocketAddress localPeer, InetSocketAddress remotePeer) throws PacketHandlerException {
        return this.handle(packet, packet.length, 0, localPeer, remotePeer);
    }

    public byte[] handle(byte[] packet, int dataLength, int offset, InetSocketAddress localPeer, InetSocketAddress remotePeer) throws PacketHandlerException {
        try {
            StunMessage message = StunMessage.decode((byte[])packet, (char)((char)offset), (char)((char)dataLength));
            if (message instanceof StunRequest) {
                return this.processRequest((StunRequest)message, localPeer, remotePeer);
            }
            if (message instanceof StunResponse) {
                return this.processResponse((StunResponse)message);
            }
            return null;
        }
        catch (StunException e) {
            throw new PacketHandlerException("Could not decode STUN packet", (Throwable)e);
        }
        catch (IOException e) {
            throw new PacketHandlerException(e.getMessage(), (Throwable)e);
        }
    }

    private byte[] processRequest(StunRequest request, InetSocketAddress localPeer, InetSocketAddress remotePeer) throws IOException, StunException {
        byte[] transactionID = request.getTransactionId();
        UsernameAttribute remoteUnameAttribute = (UsernameAttribute)request.getAttribute('\u0006');
        if (remoteUnameAttribute == null) {
            StunResponse errorResponse = new StunResponse();
            errorResponse.setTransactionID(transactionID);
            errorResponse.setMessageType('\u0111');
            errorResponse.addAttribute((StunAttribute)StunAttributeFactory.createErrorCodeAttribute((char)'\u0190', (String)ErrorCodeAttribute.getDefaultReasonPhrase((char)'\u0190')));
            return errorResponse.encode();
        }
        String remoteUsername = new String(remoteUnameAttribute.getUsername());
        if (!this.authenticator.validateUsername(remoteUsername)) {
            throw new IOException("Invalid username " + remoteUsername);
        }
        int colon = remoteUsername.indexOf(":");
        String localUFrag = remoteUsername.substring(0, colon);
        String remoteUfrag = remoteUsername.substring(colon + 1);
        TransportAddress transportAddress = new TransportAddress(remotePeer.getAddress(), remotePeer.getPort(), TransportAddress.TransportProtocol.UDP);
        StunResponse response = StunMessageFactory.createBindingResponse((StunRequest)request, (TransportAddress)transportAddress);
        try {
            response.setTransactionID(transactionID);
        }
        catch (StunException e) {
            throw new IOException("Illegal STUN Transaction ID: " + new String(transactionID), e);
        }
        String localUsername = remoteUfrag.concat(":").concat(localUFrag);
        UsernameAttribute unameAttribute = StunAttributeFactory.createUsernameAttribute((String)localUsername);
        response.addAttribute((StunAttribute)unameAttribute);
        byte[] localKey = this.authenticator.getLocalKey(localUFrag);
        MessageIntegrityAttribute integrityAttribute = StunAttributeFactory.createMessageIntegrityAttribute((String)remoteUsername, (byte[])localKey);
        response.addAttribute((StunAttribute)integrityAttribute);
        if (request.containsAttribute('%') && !this.candidateSelected.get()) {
            this.candidateSelected.set(true);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Selected candidate " + remotePeer.toString()));
            }
            this.iceListener.onSelectedCandidates(new SelectedCandidatesEvent(remotePeer));
        }
        return response.encode();
    }

    private byte[] processResponse(StunResponse response) {
        throw new UnsupportedOperationException("Support to handle STUN responses is not implemented.");
    }

    public int getPipelinePriority() {
        return this.pipelinePriority;
    }

    public void setPipelinePriority(int pipelinePriority) {
        this.pipelinePriority = pipelinePriority;
    }

    public void reset() {
        this.authenticator = null;
        this.candidateSelected.set(false);
    }
}

