/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.ice.network.stun;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.restcomm.media.ice.IceAuthenticator;
import org.restcomm.media.ice.network.stun.BindingSuccessEvent;
import org.restcomm.media.ice.network.stun.StunListener;
import org.restcomm.media.network.deprecated.TransportAddress;
import org.restcomm.media.network.deprecated.channel.PacketHandler;
import org.restcomm.media.network.deprecated.channel.PacketHandlerException;
import org.restcomm.media.stun.StunException;
import org.restcomm.media.stun.messages.StunMessage;
import org.restcomm.media.stun.messages.StunMessageFactory;
import org.restcomm.media.stun.messages.StunRequest;
import org.restcomm.media.stun.messages.StunResponse;
import org.restcomm.media.stun.messages.attributes.StunAttribute;
import org.restcomm.media.stun.messages.attributes.StunAttributeFactory;
import org.restcomm.media.stun.messages.attributes.general.ErrorCodeAttribute;
import org.restcomm.media.stun.messages.attributes.general.MessageIntegrityAttribute;
import org.restcomm.media.stun.messages.attributes.general.PriorityAttribute;
import org.restcomm.media.stun.messages.attributes.general.UsernameAttribute;

public class StunHandler
implements PacketHandler {
    private int pipelinePriority;
    private IceAuthenticator iceAuthenticator;
    private final List<StunListener> listeners;

    public StunHandler(IceAuthenticator authenticator) {
        this.iceAuthenticator = authenticator;
        this.listeners = new ArrayList<StunListener>();
        this.pipelinePriority = 0;
    }

    public int getPipelinePriority() {
        return this.pipelinePriority;
    }

    public void setPipelinePriority(int pipelinePriority) {
        this.pipelinePriority = pipelinePriority;
    }

    public IceAuthenticator getIceAuthenticator() {
        return this.iceAuthenticator;
    }

    public void setIceAuthenticator(IceAuthenticator iceAuthenticator) {
        this.iceAuthenticator = iceAuthenticator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(StunListener listener) {
        List<StunListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(StunListener listener) {
        List<StunListener> list = this.listeners;
        synchronized (list) {
            return this.listeners.remove(listener);
        }
    }

    private void fireStunBindingEvent(InetSocketAddress localPeer, InetSocketAddress remotePeer) {
        BindingSuccessEvent event = new BindingSuccessEvent(this, localPeer, remotePeer);
        for (StunListener listener : this.listeners) {
            listener.onBinding(event);
        }
    }

    private long extractPriority(StunRequest request) throws IllegalArgumentException {
        PriorityAttribute priorityAttr = (PriorityAttribute)request.getAttribute('$');
        if (priorityAttr == null) {
            throw new IllegalArgumentException("Missing PRIORITY attribtue!");
        }
        return priorityAttr.getPriority();
    }

    private byte[] processRequest(StunRequest request, InetSocketAddress localPeer, InetSocketAddress remotePeer) throws IOException, StunException {
        byte[] transactionID = request.getTransactionId();
        UsernameAttribute remoteUnameAttribute = (UsernameAttribute)request.getAttribute('\u0006');
        if (remoteUnameAttribute == null) {
            StunResponse errorResponse = new StunResponse();
            errorResponse.setTransactionID(transactionID);
            errorResponse.setMessageType('\u0111');
            errorResponse.addAttribute((StunAttribute)StunAttributeFactory.createErrorCodeAttribute((char)'\u0190', (String)ErrorCodeAttribute.getDefaultReasonPhrase((char)'\u0190')));
            return errorResponse.encode();
        }
        String remoteUsername = new String(remoteUnameAttribute.getUsername());
        if (!this.iceAuthenticator.validateUsername(remoteUsername)) {
            throw new IOException("Invalid username " + remoteUsername);
        }
        int colon = remoteUsername.indexOf(":");
        String localUFrag = remoteUsername.substring(0, colon);
        String remoteUfrag = remoteUsername.substring(colon);
        long priority = this.extractPriority(request);
        TransportAddress transportAddress = new TransportAddress(remotePeer.getAddress(), remotePeer.getPort(), TransportAddress.TransportProtocol.UDP);
        StunResponse response = StunMessageFactory.createBindingResponse((StunRequest)request, (TransportAddress)transportAddress);
        try {
            response.setTransactionID(transactionID);
        }
        catch (StunException e) {
            throw new IOException("Illegal STUN Transaction ID: " + new String(transactionID), e);
        }
        String localUsername = remoteUfrag.concat(":").concat(localUFrag);
        UsernameAttribute unameAttribute = StunAttributeFactory.createUsernameAttribute((String)localUsername);
        response.addAttribute((StunAttribute)unameAttribute);
        byte[] localKey = this.iceAuthenticator.getLocalKey(localUFrag);
        MessageIntegrityAttribute messageIntegrityAttribute = StunAttributeFactory.createMessageIntegrityAttribute((String)remoteUsername, (byte[])localKey);
        response.addAttribute((StunAttribute)messageIntegrityAttribute);
        if (request.containsAttribute('%')) {
            this.fireStunBindingEvent(localPeer, remotePeer);
        }
        return response.encode();
    }

    private byte[] processResponse(StunResponse response) {
        throw new UnsupportedOperationException("Support to handle STUN responses is not implemented.");
    }

    public boolean canHandle(byte[] packet) {
        return this.canHandle(packet, packet.length, 0);
    }

    public boolean canHandle(byte[] data, int length, int offset) {
        if (length >= 20) {
            byte b0 = data[offset];
            boolean firstBitsValid = (b0 & 0xC0) == 0;
            boolean hasMagicCookie = data[offset + 4] == StunMessage.MAGIC_COOKIE[0] && data[offset + 5] == StunMessage.MAGIC_COOKIE[1] && data[offset + 6] == StunMessage.MAGIC_COOKIE[2] && data[offset + 7] == StunMessage.MAGIC_COOKIE[3];
            return firstBitsValid && hasMagicCookie;
        }
        return false;
    }

    public byte[] handle(byte[] packet, InetSocketAddress localPeer, InetSocketAddress remotePeer) throws PacketHandlerException {
        return this.handle(packet, packet.length, 0, localPeer, remotePeer);
    }

    public byte[] handle(byte[] packet, int dataLength, int offset, InetSocketAddress localPeer, InetSocketAddress remotePeer) throws PacketHandlerException {
        try {
            StunMessage message = StunMessage.decode((byte[])packet, (char)((char)offset), (char)((char)dataLength));
            if (message instanceof StunRequest) {
                return this.processRequest((StunRequest)message, localPeer, remotePeer);
            }
            if (message instanceof StunResponse) {
                return this.processResponse((StunResponse)message);
            }
            return null;
        }
        catch (StunException e) {
            throw new PacketHandlerException("Could not decode STUN packet", (Throwable)e);
        }
        catch (IOException e) {
            throw new PacketHandlerException(e.getMessage(), (Throwable)e);
        }
    }

    public int compareTo(PacketHandler o) {
        if (o == null) {
            return 1;
        }
        return this.getPipelinePriority() - o.getPipelinePriority();
    }
}

