/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.network.deprecated.channel;

import java.net.InetSocketAddress;
import org.apache.log4j.Logger;
import org.restcomm.media.network.deprecated.IPAddressCompare;
import org.restcomm.media.network.deprecated.channel.NetworkChannel;
import org.restcomm.media.network.deprecated.channel.NetworkGuard;

public class RestrictedNetworkGuard
implements NetworkGuard {
    private static final Logger log = Logger.getLogger(RestrictedNetworkGuard.class);
    private final String network;
    private final String subnet;

    public RestrictedNetworkGuard(String network, String subnet) {
        this.network = network;
        this.subnet = subnet;
    }

    @Override
    public boolean isSecure(NetworkChannel channel, InetSocketAddress source) {
        byte[] networkBytes = IPAddressCompare.addressToByteArrayV4(this.network);
        byte[] subnetBytes = IPAddressCompare.addressToByteArrayV4(this.subnet);
        boolean secure = IPAddressCompare.isInRangeV4(networkBytes, subnetBytes, source.getAddress().getAddress());
        if (log.isTraceEnabled()) {
            log.trace((Object)("Is packet secure? " + secure + " [network=" + this.network + ", subnet=" + this.subnet + ", remote address=" + source.getAddress().getHostAddress() + "]"));
        }
        return secure;
    }
}

