/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.network.netty.channel;

import com.google.common.util.concurrent.FutureCallback;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import org.restcomm.media.network.api.AsynchronousNetworkChannel;
import org.restcomm.media.network.netty.NettyNetworkManager;
import org.restcomm.media.network.netty.channel.NettyNetworkChannelEvent;
import org.restcomm.media.network.netty.channel.NettyNetworkChannelFsm;
import org.restcomm.media.network.netty.channel.NettyNetworkChannelFsmBuilder;
import org.restcomm.media.network.netty.channel.NettyNetworkChannelGlobalContext;
import org.restcomm.media.network.netty.channel.NettyNetworkChannelState;
import org.restcomm.media.network.netty.channel.NettyNetworkChannelTransitionContext;

public class AsyncNettyNetworkChannel<M>
implements AsynchronousNetworkChannel<M> {
    public static final int N_THREADS = 1;
    private final NettyNetworkChannelGlobalContext context;
    private final NettyNetworkChannelFsm fsm;

    public AsyncNettyNetworkChannel(NettyNetworkManager networkManager) {
        this(new NettyNetworkChannelGlobalContext(networkManager));
    }

    public AsyncNettyNetworkChannel(NettyNetworkChannelGlobalContext context) {
        this.context = context;
        this.fsm = NettyNetworkChannelFsmBuilder.INSTANCE.build(this.context);
        this.fsm.start();
    }

    @Override
    public boolean isOpen() {
        NettyNetworkChannelState state = (NettyNetworkChannelState)((Object)this.fsm.getCurrentState());
        switch (state) {
            case UNINITIALIZED: 
            case OPENING: 
            case CLOSING: 
            case CLOSED: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isBound() {
        NettyNetworkChannelState state = (NettyNetworkChannelState)((Object)this.fsm.getCurrentState());
        switch (state) {
            case BOUND: 
            case CONNECTING: 
            case CONNECTED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.isBound() ? this.context.getLocalAddress() : null;
    }

    @Override
    public boolean isConnected() {
        return NettyNetworkChannelState.CONNECTED.equals(this.fsm.getCurrentState());
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.isConnected() ? this.context.getRemoteAddress() : null;
    }

    @Override
    public void open(FutureCallback<Void> callback) {
        if (this.isOpen()) {
            callback.onFailure((Throwable)new IllegalStateException("Channel is already open."));
        } else {
            NettyNetworkChannelTransitionContext transitionContext = new NettyNetworkChannelTransitionContext().setCallback(callback);
            this.fsm.fire((Object)NettyNetworkChannelEvent.OPEN, transitionContext);
        }
    }

    @Override
    public void close(FutureCallback<Void> callback) {
        if (this.isOpen()) {
            NettyNetworkChannelTransitionContext transitionContext = new NettyNetworkChannelTransitionContext().setCallback(callback);
            this.fsm.fire((Object)NettyNetworkChannelEvent.CLOSE, transitionContext);
        } else {
            callback.onFailure((Throwable)new IllegalStateException("Channel is already closed."));
        }
    }

    @Override
    public void bind(SocketAddress localAddress, FutureCallback<Void> callback) {
        if (this.isBound()) {
            callback.onFailure((Throwable)new IllegalStateException("Channel is already bound."));
        } else {
            this.context.setLocalAddress(localAddress);
            NettyNetworkChannelTransitionContext transitionContext = new NettyNetworkChannelTransitionContext().setCallback(callback);
            this.fsm.fire((Object)NettyNetworkChannelEvent.BIND, transitionContext);
        }
    }

    @Override
    public void connect(SocketAddress remoteAddress, FutureCallback<Void> callback) {
        if (this.isConnected()) {
            callback.onFailure((Throwable)new IllegalStateException("Channel is already bound."));
        } else {
            this.context.setRemoteAddress(remoteAddress);
            NettyNetworkChannelTransitionContext transitionContext = new NettyNetworkChannelTransitionContext().setCallback(callback);
            this.fsm.fire((Object)NettyNetworkChannelEvent.CONNECT, transitionContext);
        }
    }

    @Override
    public void disconnect(FutureCallback<Void> callback) {
        if (this.isConnected()) {
            NettyNetworkChannelTransitionContext transitionContext = new NettyNetworkChannelTransitionContext().setCallback(callback);
            this.fsm.fire((Object)NettyNetworkChannelEvent.DISCONNECT, transitionContext);
        } else {
            callback.onFailure((Throwable)new IllegalStateException("Channel is not connected."));
        }
    }

    @Override
    public void receive() {
        if (this.isBound()) {
            this.context.getChannel().read();
        }
    }

    @Override
    public void send(M message, FutureCallback<Void> callback) {
        if (this.isConnected()) {
            ChannelFuture future = this.context.getChannel().writeAndFlush(message);
            future.addListener((GenericFutureListener)new NettyNetworkChannelVoidCallbackListener(callback));
        } else {
            callback.onFailure((Throwable)new IllegalStateException("Channel is not connected."));
        }
    }

    @Override
    public void send(M message, SocketAddress remoteAddress, FutureCallback<Void> callback) {
        if (this.isBound()) {
            if (this.isConnected()) {
                callback.onFailure((Throwable)new IllegalStateException("Channel is connected. Cannot send traffic to another peer."));
            } else {
                DefaultAddressedEnvelope envelope = new DefaultAddressedEnvelope(message, remoteAddress);
                ChannelFuture future = this.context.getChannel().writeAndFlush((Object)envelope);
                future.addListener((GenericFutureListener)new NettyNetworkChannelVoidCallbackListener(callback));
            }
        } else {
            callback.onFailure((Throwable)new IllegalStateException("Channel is not bound."));
        }
    }

    static final class NettyNetworkChannelVoidCallbackListener
    implements ChannelFutureListener {
        private final FutureCallback<Void> observer;

        public NettyNetworkChannelVoidCallbackListener(FutureCallback<Void> observer) {
            this.observer = observer;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                this.observer.onSuccess(null);
            } else {
                this.observer.onFailure(future.cause());
            }
        }
    }
}

