/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.network.netty.filter;

import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import org.apache.log4j.Logger;
import org.restcomm.media.network.deprecated.IPAddressCompare;
import org.restcomm.media.network.deprecated.channel.RestrictedNetworkGuard;
import org.restcomm.media.network.netty.filter.NetworkGuard;

public class LocalNetworkGuard
implements NetworkGuard {
    private static final Logger log = Logger.getLogger(RestrictedNetworkGuard.class);
    private final String network;
    private final String subnet;

    public LocalNetworkGuard(String network, String subnet) {
        this.network = network;
        this.subnet = subnet;
    }

    @Override
    public boolean isSecure(Channel channel, InetSocketAddress source) {
        byte[] subnetBytes;
        byte[] networkBytes = IPAddressCompare.addressToByteArrayV4(this.network);
        boolean secure = IPAddressCompare.isInRangeV4(networkBytes, subnetBytes = IPAddressCompare.addressToByteArrayV4(this.subnet), source.getAddress().getAddress());
        if (!secure && log.isTraceEnabled()) {
            log.trace((Object)("Dropped insecure packet [network=" + this.network + ", subnet=" + this.subnet + ", remote address=" + source.getAddress().getHostAddress() + "]"));
        }
        return secure;
    }
}

