/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.network.netty.filter;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.log4j.Logger;
import org.restcomm.media.network.netty.filter.NetworkGuard;

public class SbcNetworkGuard
implements NetworkGuard {
    private static final Logger log = Logger.getLogger(SbcNetworkGuard.class);

    @Override
    public boolean isSecure(Channel channel, InetSocketAddress source) {
        if (channel.isActive()) {
            return channel.remoteAddress().equals(source);
        }
        try {
            ChannelFuture future = channel.connect((SocketAddress)source).sync();
            return future.isSuccess();
        }
        catch (Exception e) {
            log.warn((Object)"Could not connect channel", (Throwable)e);
            return false;
        }
    }
}

