/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.network.deprecated;

import java.util.concurrent.atomic.AtomicInteger;
import org.restcomm.media.network.deprecated.PortManager;

public class RtpPortManager
implements PortManager {
    public static final int MIN_PORT = 1024;
    public static final int MAX_PORT = 65534;
    private final int minimum;
    private final int maximum;
    private final int step;
    private final AtomicInteger current;

    public RtpPortManager(int minimum, int maximum) {
        this.minimum = minimum % 2 == 0 ? minimum : minimum + 1;
        this.maximum = maximum % 2 == 0 ? maximum : maximum - 1;
        this.step = (this.maximum - this.minimum) / 2;
        this.current = new AtomicInteger(0);
    }

    public RtpPortManager() {
        this(1024, 65534);
    }

    @Override
    public int getLowest() {
        return this.minimum;
    }

    @Override
    public int getHighest() {
        return this.maximum;
    }

    @Override
    public int next() {
        return this.maximum - this.current.getAndAdd(1) % this.step * 2;
    }

    @Override
    public int peek() {
        return this.maximum - (this.current.get() + 1) % this.step * 2;
    }

    @Override
    public int current() {
        return this.maximum - this.current.get() % this.step * 2;
    }
}

