/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.network.deprecated.channel;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import org.apache.log4j.Logger;
import org.restcomm.media.network.deprecated.channel.NetworkChannel;
import org.restcomm.media.network.deprecated.channel.NetworkGuard;

public abstract class AbstractNetworkChannel
implements NetworkChannel {
    protected SelectionKey selectionKey;
    protected DatagramChannel dataChannel;
    private static final int BUFFER_SIZE = 8192;
    private final ByteBuffer receiveBuffer = ByteBuffer.allocate(8192);
    private final NetworkGuard guard;

    public AbstractNetworkChannel(NetworkGuard guard) {
        this.guard = guard;
    }

    @Override
    public void bind(InetSocketAddress address) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("The channel is closed.");
        }
        this.dataChannel.bind(address);
    }

    @Override
    public void open() throws IOException {
        if (this.isOpen()) {
            throw new IOException("Channel is already open.");
        }
        this.dataChannel = DatagramChannel.open();
        this.dataChannel.configureBlocking(false);
    }

    @Override
    public void close() {
        if (this.isOpen()) {
            if (this.isConnected()) {
                try {
                    this.disconnect();
                }
                catch (IOException e) {
                    this.log().warn((Object)"Was unable to disconnect channel", (Throwable)e);
                }
            }
            if (this.isRegistered()) {
                this.selectionKey.cancel();
            }
            try {
                this.dataChannel.close();
            }
            catch (IOException e) {
                this.log().error((Object)"Could not close channel.", (Throwable)e);
            }
        }
    }

    @Override
    public void register(Selector selector, int opts) throws ClosedChannelException {
        SelectionKey key = this.dataChannel.register(selector, opts);
        key.attach(this);
    }

    @Override
    public void connect(InetSocketAddress address) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("The channel is closed.");
        }
        this.dataChannel.connect(address);
    }

    @Override
    public void disconnect() throws IOException {
        if (this.isConnected()) {
            this.dataChannel.disconnect();
        }
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        if (this.isOpen()) {
            try {
                SocketAddress address = this.dataChannel.getLocalAddress();
                return address == null ? null : (InetSocketAddress)address;
            }
            catch (IOException e) {
                this.log().warn((Object)"Cannot retrieve local address.", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        if (this.isConnected()) {
            try {
                SocketAddress address = this.dataChannel.getRemoteAddress();
                return address == null ? null : (InetSocketAddress)address;
            }
            catch (IOException e) {
                this.log().warn((Object)"Cannot retrieve remote address.", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public boolean isOpen() {
        return this.dataChannel != null && this.dataChannel.isOpen();
    }

    @Override
    public boolean isConnected() {
        return this.dataChannel != null && this.dataChannel.isConnected();
    }

    @Override
    public boolean isRegistered() {
        return this.selectionKey != null && this.selectionKey.isValid();
    }

    @Override
    public void receive() throws IOException {
        this.receiveBuffer.clear();
        InetSocketAddress remotePeer = null;
        int dataLength = 0;
        try {
            remotePeer = (InetSocketAddress)this.dataChannel.receive(this.receiveBuffer);
            dataLength = this.receiveBuffer.position();
        }
        catch (IOException e) {
            dataLength = -1;
        }
        if (dataLength == -1) {
            this.close();
            return;
        }
        if (dataLength > 0 && this.guard.isSecure(this, remotePeer)) {
            byte[] dataCopy = new byte[dataLength];
            this.receiveBuffer.rewind();
            this.receiveBuffer.get(dataCopy, 0, dataLength);
            this.onIncomingPacket(dataCopy, remotePeer);
        }
    }

    @Override
    public void send(byte[] data) throws IOException {
        if (!this.isConnected()) {
            throw new IOException("Channel is not connected");
        }
        this.dataChannel.send(ByteBuffer.wrap(data), this.dataChannel.getRemoteAddress());
    }

    @Override
    public void send(byte[] data, InetSocketAddress remotePeer) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("Channel is closed.");
        }
        this.dataChannel.send(ByteBuffer.wrap(data), remotePeer);
    }

    @Override
    public void send(ByteBuffer data, InetSocketAddress remotePeer) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("Channel is closed.");
        }
        this.dataChannel.send(data, remotePeer);
    }

    protected abstract void onIncomingPacket(byte[] var1, InetSocketAddress var2);

    protected abstract Logger log();
}

