/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.network.deprecated.channel;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.log4j.Logger;
import org.restcomm.media.network.deprecated.channel.AbstractNetworkChannel;
import org.restcomm.media.network.deprecated.channel.NetworkGuard;
import org.restcomm.media.network.deprecated.channel.PacketHandler;
import org.restcomm.media.network.deprecated.channel.PacketHandlerException;
import org.restcomm.media.network.deprecated.channel.PacketHandlerPipeline;

public class MultiplexedNetworkChannel
extends AbstractNetworkChannel {
    private static final Logger log = Logger.getLogger(MultiplexedNetworkChannel.class);
    protected final PacketHandlerPipeline handlers = new PacketHandlerPipeline();

    public MultiplexedNetworkChannel(NetworkGuard guard, PacketHandler ... handlers) {
        super(guard);
        for (PacketHandler handler : handlers) {
            this.handlers.addHandler(handler);
        }
    }

    @Override
    protected void onIncomingPacket(byte[] data, InetSocketAddress remotePeer) {
        PacketHandler handler = this.handlers.getHandler(data);
        if (handler == null) {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"No protocol handler was found to process an incoming packet. Packet will be dropped.");
            }
        } else {
            try {
                byte[] response = handler.handle(data, this.getLocalAddress(), remotePeer);
                if (response != null && response.length > 0) {
                    this.send(response, remotePeer);
                }
            }
            catch (PacketHandlerException e) {
                this.log().warn((Object)(handler.getClass().getSimpleName() + " could not handle incoming packet: " + e.getMessage()));
            }
            catch (IOException e) {
                this.log().warn((Object)(handler.getClass().getSimpleName() + " could not send response to remote peer " + remotePeer.getAddress().toString()));
            }
        }
    }

    @Override
    protected Logger log() {
        return log;
    }
}

