/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.network.deprecated.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.restcomm.media.network.deprecated.netty.NetworkManager;

public class UdpNetworkManager
implements NetworkManager {
    public static final int N_THREADS = Runtime.getRuntime().availableProcessors();
    public static final long SHUTDOWN_TIME = 5L;
    private EventLoopGroup eventGroup;
    private final AtomicBoolean active = new AtomicBoolean(false);

    @Override
    public ChannelFuture bindDatagramChannel(String address, int port, ChannelHandler handler) throws IllegalStateException {
        if (this.active.get()) {
            Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.eventGroup)).channel(NioDatagramChannel.class)).handler(handler);
            return bootstrap.bind(address, port);
        }
        throw new IllegalStateException("Network manager is not active.");
    }

    @Override
    public void activate() throws IllegalStateException {
        if (this.active.get()) {
            throw new IllegalStateException("Network Manager is already active");
        }
        this.eventGroup = new NioEventLoopGroup(N_THREADS, (ThreadFactory)new DefaultThreadFactory("netty-client-"));
        this.active.set(true);
    }

    @Override
    public void deactivate() throws IllegalStateException {
        if (!this.active.get()) {
            throw new IllegalStateException("Network Manager is already inactive");
        }
        this.eventGroup.shutdownGracefully(0L, 5L, TimeUnit.SECONDS);
        this.active.set(false);
    }

    @Override
    public boolean isActive() {
        return this.active.get();
    }
}

