/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.network.netty;

import com.google.common.util.concurrent.FutureCallback;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.restcomm.media.network.api.AsynchronousNetworkManager;
import org.restcomm.media.network.api.SynchronousNetworkManager;

public class NettyNetworkManager
implements SynchronousNetworkManager<Channel>,
AsynchronousNetworkManager<Channel> {
    static final long SHUTDOWN_TIMEOUT = 5L;
    static final int N_THREADS = Runtime.getRuntime().availableProcessors();
    protected final EventLoopGroup eventGroup;
    protected final Bootstrap bootstrap;
    private final AtomicBoolean open;

    public NettyNetworkManager() {
        this(N_THREADS);
    }

    public NettyNetworkManager(int threadCount) {
        this((Bootstrap)((Bootstrap)new Bootstrap().channel(NioDatagramChannel.class)).group((EventLoopGroup)new NioEventLoopGroup(threadCount)));
    }

    public NettyNetworkManager(Bootstrap bootstrap) {
        this.bootstrap = bootstrap;
        this.eventGroup = bootstrap.group();
        this.open = new AtomicBoolean(true);
    }

    @Override
    public Channel openChannel() throws IOException, IllegalStateException {
        this.assertOpen();
        try {
            return this.bootstrap.clone().register().sync().channel();
        }
        catch (Exception e) {
            throw new IOException("Could not open channel.", e);
        }
    }

    @Override
    public void openChannel(FutureCallback<Channel> callback) throws IllegalStateException {
        this.assertOpen();
        ChannelFuture future = this.bootstrap.clone().register();
        future.addListener((GenericFutureListener)new NetworkManagerChannelFutureCallback(callback));
    }

    @Override
    public void close() throws IOException, IllegalStateException {
        if (this.open.compareAndSet(true, false)) {
            try {
                this.eventGroup.shutdownGracefully(0L, 5L, TimeUnit.SECONDS).sync();
            }
            catch (Exception e) {
                throw new IOException("Could not be gracefully closed.", e);
            }
        } else {
            throw new IllegalStateException("Network Manager is already closed");
        }
    }

    @Override
    public void close(FutureCallback<Void> callback) throws IllegalStateException {
        this.assertOpen();
        Future future = this.eventGroup.shutdownGracefully(0L, 5L, TimeUnit.SECONDS);
        future.addListener((GenericFutureListener)new NetworkManagerVoidFutureCallback(callback));
    }

    private void assertOpen() throws IllegalStateException {
        if (!this.open.get()) {
            throw new IllegalStateException("Network Manager is already closed.");
        }
    }

    private static final class NetworkManagerChannelFutureCallback
    implements GenericFutureListener<ChannelFuture> {
        private final FutureCallback<Channel> callback;

        public NetworkManagerChannelFutureCallback(FutureCallback<Channel> callback) {
            this.callback = callback;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                this.callback.onSuccess((Object)future.channel());
            } else {
                this.callback.onFailure(future.cause());
            }
        }
    }

    private static final class NetworkManagerVoidFutureCallback
    implements GenericFutureListener<Future<Object>> {
        private final FutureCallback<Void> callback;

        public NetworkManagerVoidFutureCallback(FutureCallback<Void> callback) {
            this.callback = callback;
        }

        public void operationComplete(Future<Object> future) throws Exception {
            if (future.isSuccess()) {
                this.callback.onSuccess(null);
            } else {
                this.callback.onFailure(future.cause());
            }
        }
    }
}

