/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.network.deprecated;

import org.restcomm.media.network.deprecated.IPAddressType;
import sun.net.util.IPAddressUtil;

public class IPAddressCompare {
    public static boolean isInRangeV4(byte[] network, byte[] subnet, byte[] ipAddress) {
        if (network.length != 4 || subnet.length != 4 || ipAddress.length != 4) {
            return false;
        }
        return IPAddressCompare.compareByteValues(network, subnet, ipAddress);
    }

    public static boolean isInRangeV6(byte[] network, byte[] subnet, byte[] ipAddress) {
        if (network.length != 16 || subnet.length != 16 || ipAddress.length != 16) {
            return false;
        }
        return IPAddressCompare.compareByteValues(network, subnet, ipAddress);
    }

    private static boolean compareByteValues(byte[] network, byte[] subnet, byte[] ipAddress) {
        for (int i = 0; i < network.length; ++i) {
            if ((network[i] & subnet[i]) == (ipAddress[i] & subnet[i])) continue;
            return false;
        }
        return true;
    }

    public static IPAddressType getAddressType(String ipAddress) {
        if (IPAddressUtil.isIPv4LiteralAddress(ipAddress)) {
            return IPAddressType.IPV4;
        }
        if (IPAddressUtil.isIPv6LiteralAddress(ipAddress)) {
            return IPAddressType.IPV6;
        }
        return IPAddressType.INVALID;
    }

    public static byte[] addressToByteArrayV4(String ipAddress) {
        return IPAddressUtil.textToNumericFormatV4(ipAddress);
    }

    public static byte[] addressToByteArrayV6(String ipAddress) {
        return IPAddressUtil.textToNumericFormatV6(ipAddress);
    }
}

