/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.network.netty.channel;

import com.google.common.util.concurrent.FutureCallback;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import org.apache.log4j.Logger;
import org.restcomm.media.network.netty.channel.AbstractNettyNetworkChannelFsm;
import org.restcomm.media.network.netty.channel.NettyNetworkChannelEvent;
import org.restcomm.media.network.netty.channel.NettyNetworkChannelGlobalContext;
import org.restcomm.media.network.netty.channel.NettyNetworkChannelState;
import org.restcomm.media.network.netty.channel.NettyNetworkChannelTransitionContext;

public class AsyncNettyNetworkChannelFsm
extends AbstractNettyNetworkChannelFsm {
    private static final Logger log = Logger.getLogger(AsyncNettyNetworkChannelFsm.class);
    private final NettyNetworkChannelGlobalContext globalContext;

    public AsyncNettyNetworkChannelFsm(NettyNetworkChannelGlobalContext globalContext) {
        this.globalContext = globalContext;
    }

    @Override
    public void enterOpening(NettyNetworkChannelState from, NettyNetworkChannelState to, NettyNetworkChannelEvent event, NettyNetworkChannelTransitionContext context) {
        this.globalContext.getNetworkManager().openChannel(new OpenCallback(context));
    }

    @Override
    public void enterBinding(NettyNetworkChannelState from, NettyNetworkChannelState to, NettyNetworkChannelEvent event, NettyNetworkChannelTransitionContext context) {
        ChannelFuture future = this.globalContext.getChannel().bind(this.globalContext.getLocalAddress());
        future.addListener((GenericFutureListener)new BindCallback(context));
    }

    @Override
    public void enterConnecting(NettyNetworkChannelState from, NettyNetworkChannelState to, NettyNetworkChannelEvent event, NettyNetworkChannelTransitionContext context) {
        ChannelFuture future = this.globalContext.getChannel().connect(this.globalContext.getRemoteAddress());
        future.addListener((GenericFutureListener)new ConnectCallback(context));
    }

    @Override
    public void enterDisconnecting(NettyNetworkChannelState from, NettyNetworkChannelState to, NettyNetworkChannelEvent event, NettyNetworkChannelTransitionContext context) {
        ChannelFuture future = this.globalContext.getChannel().disconnect();
        future.addListener((GenericFutureListener)new DisconnectCallback(context));
    }

    @Override
    public void exitDisconnecting(NettyNetworkChannelState from, NettyNetworkChannelState to, NettyNetworkChannelEvent event, NettyNetworkChannelTransitionContext context) {
        this.globalContext.setRemoteAddress(null);
    }

    @Override
    public void enterClosing(NettyNetworkChannelState from, NettyNetworkChannelState to, NettyNetworkChannelEvent event, NettyNetworkChannelTransitionContext context) {
        ChannelFuture future = this.globalContext.getChannel().close();
        future.addListener((GenericFutureListener)new CloseCallback(context));
    }

    @Override
    public void enterClosed(NettyNetworkChannelState from, NettyNetworkChannelState to, NettyNetworkChannelEvent event, NettyNetworkChannelTransitionContext context) {
        this.globalContext.clean();
    }

    private final class CloseCallback
    implements ChannelFutureListener {
        private final NettyNetworkChannelTransitionContext context;

        public CloseCallback(NettyNetworkChannelTransitionContext context) {
            this.context = context;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Channel closed in elegant manner");
                }
                this.context.getCallback().onSuccess(null);
            } else {
                log.warn((Object)"Channel could not be closed properly", future.cause());
                this.context.getCallback().onFailure(future.cause());
            }
            AsyncNettyNetworkChannelFsm.this.fire((Object)NettyNetworkChannelEvent.CLOSED, this.context);
        }
    }

    private final class DisconnectCallback
    implements ChannelFutureListener {
        private final NettyNetworkChannelTransitionContext context;

        public DisconnectCallback(NettyNetworkChannelTransitionContext context) {
            this.context = context;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Channel disconnected from " + future.channel().remoteAddress().toString()));
                }
                AsyncNettyNetworkChannelFsm.this.fire((Object)NettyNetworkChannelEvent.DISCONNECTED, this.context);
                this.context.getCallback().onSuccess(null);
            } else {
                log.warn((Object)("Could not disconnect channel from " + AsyncNettyNetworkChannelFsm.this.globalContext.getRemoteAddress() + ". Channel will be closed."), future.cause());
                AsyncNettyNetworkChannelFsm.this.fire((Object)NettyNetworkChannelEvent.CLOSE, this.context);
                this.context.getCallback().onFailure(future.cause());
            }
        }
    }

    private final class ConnectCallback
    implements ChannelFutureListener {
        private final NettyNetworkChannelTransitionContext context;

        public ConnectCallback(NettyNetworkChannelTransitionContext context) {
            this.context = context;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Channel is connected to " + future.channel().remoteAddress().toString()));
                }
                AsyncNettyNetworkChannelFsm.this.fire((Object)NettyNetworkChannelEvent.CONNECTED, this.context);
                this.context.getCallback().onSuccess(null);
            } else {
                log.warn((Object)("Could not connect channel to " + AsyncNettyNetworkChannelFsm.this.globalContext.getRemoteAddress() + ". Channel will be closed."), future.cause());
                AsyncNettyNetworkChannelFsm.this.fire((Object)NettyNetworkChannelEvent.CLOSE, this.context);
                this.context.getCallback().onFailure(future.cause());
            }
        }
    }

    private final class BindCallback
    implements ChannelFutureListener {
        private final NettyNetworkChannelTransitionContext context;

        public BindCallback(NettyNetworkChannelTransitionContext context) {
            this.context = context;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Channel is bound to " + future.channel().localAddress().toString()));
                }
                AsyncNettyNetworkChannelFsm.this.fire((Object)NettyNetworkChannelEvent.BOUND, this.context);
                this.context.getCallback().onSuccess(null);
            } else {
                log.warn((Object)("Could not bind channel to " + AsyncNettyNetworkChannelFsm.this.globalContext.getLocalAddress() + ". Channel will be closed."), future.cause());
                AsyncNettyNetworkChannelFsm.this.fire((Object)NettyNetworkChannelEvent.CLOSE, this.context);
                this.context.getCallback().onFailure(future.cause());
            }
        }
    }

    private final class OpenCallback
    implements FutureCallback<Channel> {
        private final NettyNetworkChannelTransitionContext context;

        public OpenCallback(NettyNetworkChannelTransitionContext context) {
            this.context = context;
        }

        public void onSuccess(Channel result) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Channel opened successfully");
            }
            AsyncNettyNetworkChannelFsm.this.globalContext.setChannel(result);
            AsyncNettyNetworkChannelFsm.this.fire((Object)NettyNetworkChannelEvent.OPENED, this.context);
            this.context.getCallback().onSuccess(null);
        }

        public void onFailure(Throwable t) {
            log.warn((Object)"Channel could not be opened, so will be terminated prematurely.", t);
            AsyncNettyNetworkChannelFsm.this.fire((Object)NettyNetworkChannelEvent.CLOSE, this.context);
            this.context.getCallback().onFailure(t);
        }
    }
}

