/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.network.deprecated.channel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.restcomm.media.network.deprecated.channel.PacketHandler;

public class PacketHandlerPipeline {
    private static final Comparator<PacketHandler> REVERSE_COMPARATOR = new Comparator<PacketHandler>(){

        @Override
        public int compare(PacketHandler o1, PacketHandler o2) {
            return o2.compareTo(o1);
        }
    };
    private final List<PacketHandler> handlers = new ArrayList<PacketHandler>(5);
    private final AtomicInteger count = new AtomicInteger(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addHandler(PacketHandler handler) {
        List<PacketHandler> list = this.handlers;
        synchronized (list) {
            if (!this.handlers.contains(handler)) {
                this.handlers.add(handler);
                this.count.incrementAndGet();
                Collections.sort(this.handlers, REVERSE_COMPARATOR);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeHandler(PacketHandler handler) {
        List<PacketHandler> list = this.handlers;
        synchronized (list) {
            boolean removed = this.handlers.remove(handler);
            if (removed) {
                this.count.decrementAndGet();
            }
            return removed;
        }
    }

    public int count() {
        return this.count.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(PacketHandler handler) {
        List<PacketHandler> list = this.handlers;
        synchronized (list) {
            return this.handlers.contains(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacketHandler getHandler(byte[] packet) {
        List<PacketHandler> list = this.handlers;
        synchronized (list) {
            for (PacketHandler protocolHandler : this.handlers) {
                if (!protocolHandler.canHandle(packet)) continue;
                return protocolHandler;
            }
            return null;
        }
    }

    protected List<PacketHandler> getHandlers() {
        return this.handlers;
    }
}

