/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.network.deprecated;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.restcomm.media.network.deprecated.IPAddressCompare;
import org.restcomm.media.network.deprecated.IPAddressType;
import org.restcomm.media.network.deprecated.PortManager;
import org.restcomm.media.network.deprecated.ProtocolHandler;
import org.restcomm.media.network.deprecated.channel.Channel;
import org.restcomm.media.network.deprecated.channel.NetworkChannel;
import org.restcomm.media.scheduler.Scheduler;
import org.restcomm.media.scheduler.ServiceScheduler;

public class UdpManager {
    private static final Logger logger = Logger.getLogger(UdpManager.class);
    private final Scheduler scheduler;
    private final PortManager portManager;
    private final PortManager localPortManager;
    private static final int PORT_ANY = -1;
    private static final String INET_UNKNOWN = "unknown";
    private static final String LOCALHOST = "127.0.0.1";
    private String inet;
    private String bindAddress;
    private String localBindAddress;
    private String externalAddress;
    private byte[] localNetwork;
    private String localNetworkString;
    private IPAddressType currNetworkType;
    private byte[] localSubnet;
    private String localSubnetString;
    private IPAddressType currSubnetType;
    private Boolean useSbc;
    private int rtpTimeout;
    private volatile boolean active;
    private final Object LOCK;
    private final List<Selector> selectors;
    private List<PollTask> pollTasks;
    private List<Future<?>> pollTaskFutures;
    private AtomicInteger currSelectorIndex;

    public UdpManager(Scheduler scheduler, PortManager portManager, PortManager localPortManager) {
        this.portManager = portManager;
        this.localPortManager = localPortManager;
        this.inet = INET_UNKNOWN;
        this.bindAddress = LOCALHOST;
        this.localBindAddress = LOCALHOST;
        this.externalAddress = "";
        this.useSbc = false;
        this.rtpTimeout = 0;
        this.active = false;
        this.LOCK = new Object();
        this.scheduler = scheduler;
        this.selectors = new ArrayList<Selector>(ServiceScheduler.POOL_SIZE);
        this.pollTasks = new ArrayList<PollTask>(ServiceScheduler.POOL_SIZE);
        this.pollTaskFutures = new ArrayList(ServiceScheduler.POOL_SIZE);
        this.currSelectorIndex = new AtomicInteger(0);
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setBindAddress(String address) {
        this.bindAddress = address;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public void setLocalBindAddress(String address) {
        this.localBindAddress = address;
    }

    public String getLocalBindAddress() {
        return this.localBindAddress;
    }

    public String getExternalAddress() {
        return this.externalAddress;
    }

    public void setExternalAddress(String externalAddress) {
        this.externalAddress = externalAddress;
    }

    public void setRtpTimeout(int rtpTimeout) {
        this.rtpTimeout = rtpTimeout;
    }

    public int getRtpTimeout() {
        return this.rtpTimeout;
    }

    public void setLocalNetwork(String localNetwork) {
        IPAddressType currNetworkType;
        this.currNetworkType = currNetworkType = IPAddressCompare.getAddressType(localNetwork);
        this.localNetworkString = localNetwork;
        if (currNetworkType == IPAddressType.IPV4) {
            this.localNetwork = IPAddressCompare.addressToByteArrayV4(localNetwork);
        } else if (currNetworkType == IPAddressType.IPV6) {
            this.localNetwork = IPAddressCompare.addressToByteArrayV6(localNetwork);
        }
    }

    public String getLocalNetwork() {
        return this.localNetworkString;
    }

    public void setLocalSubnet(String localSubnet) {
        IPAddressType currSubnetType;
        this.currSubnetType = currSubnetType = IPAddressCompare.getAddressType(localSubnet);
        this.localSubnetString = localSubnet;
        if (currSubnetType == IPAddressType.IPV4) {
            this.localSubnet = IPAddressCompare.addressToByteArrayV4(localSubnet);
        } else if (currSubnetType == IPAddressType.IPV6) {
            this.localSubnet = IPAddressCompare.addressToByteArrayV6(localSubnet);
        }
    }

    public String getLocalSubnet() {
        return this.localSubnetString;
    }

    public void setUseSbc(Boolean useSbc) {
        this.useSbc = useSbc;
    }

    public PortManager getPortManager() {
        return this.portManager;
    }

    public int getLowestPort() {
        return this.portManager.getLowest();
    }

    public int getHighestPort() {
        return this.portManager.getLowest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelector(Selector selector) {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.selectors.contains(selector)) {
                this.selectors.add(selector);
                PollTask pollTask = new PollTask(selector);
                this.pollTasks.add(pollTask);
                ScheduledFuture future = this.scheduler.scheduleWithFixedDelay((Runnable)pollTask, 0L, 2L, TimeUnit.MILLISECONDS);
                this.pollTaskFutures.add(future);
            }
        }
    }

    public boolean connectImmediately(InetSocketAddress address) {
        if (!this.useSbc.booleanValue()) {
            return true;
        }
        boolean connectImmediately = false;
        byte[] addressValue = address.getAddress().getAddress();
        if (this.currSubnetType == IPAddressType.IPV4 && this.currNetworkType == IPAddressType.IPV4) {
            if (IPAddressCompare.isInRangeV4(this.localNetwork, this.localSubnet, addressValue)) {
                connectImmediately = true;
            }
        } else if (this.currSubnetType == IPAddressType.IPV6 && this.currNetworkType == IPAddressType.IPV6 && IPAddressCompare.isInRangeV6(this.localNetwork, this.localSubnet, addressValue)) {
            connectImmediately = true;
        }
        return connectImmediately;
    }

    @Deprecated
    public DatagramChannel open(ProtocolHandler handler) throws IOException {
        DatagramChannel channel = DatagramChannel.open();
        channel.configureBlocking(false);
        int index = this.currSelectorIndex.getAndIncrement();
        SelectionKey key = channel.register(this.selectors.get(index % this.selectors.size()), 1);
        key.attach(handler);
        handler.setKey(key);
        return channel;
    }

    public SelectionKey open(Channel channel) throws IOException {
        DatagramChannel dataChannel = DatagramChannel.open();
        dataChannel.configureBlocking(false);
        int index = this.currSelectorIndex.getAndIncrement();
        SelectionKey key = dataChannel.register(this.selectors.get(index % this.selectors.size()), 1);
        key.attach(channel);
        return key;
    }

    public void register(NetworkChannel channel) throws IOException {
        int index = this.currSelectorIndex.getAndIncrement();
        channel.register(this.selectors.get(index % this.selectors.size()), 1);
    }

    @Deprecated
    public SelectionKey open(DatagramChannel dataChannel, Channel channel) throws IOException {
        int index = this.currSelectorIndex.getAndIncrement();
        Selector selector = this.selectors.get(index % this.selectors.size());
        SelectionKey key = dataChannel.register(selector, 1);
        key.attach(channel);
        return key;
    }

    @Deprecated
    public void open(DatagramChannel channel, ProtocolHandler handler) throws IOException {
        int index = this.currSelectorIndex.getAndIncrement();
        Selector selector = this.selectors.get(index % this.selectors.size());
        SelectionKey key = channel.register(selector, 1);
        key.attach(handler);
        handler.setKey(key);
    }

    public void bind(DatagramChannel channel, int port, boolean local) throws IOException {
        if (local) {
            this.bindLocal(channel, port);
        } else {
            this.bind(channel, port);
        }
    }

    public void bind(DatagramChannel channel, int port) throws IOException {
        if (port == -1) {
            port = this.portManager.next();
        }
        IOException ex = null;
        for (int q = 0; q < 100; ++q) {
            try {
                channel.bind(new InetSocketAddress(this.bindAddress, port));
                ex = null;
                break;
            }
            catch (IOException e) {
                ex = e;
                logger.info((Object)("Failed trying to bind " + this.bindAddress + ":" + port));
                port = this.portManager.next();
                continue;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    public void bindLocal(DatagramChannel channel, int port) throws IOException {
        if (port == -1) {
            port = this.localPortManager.next();
        }
        IOException ex = null;
        for (int q = 0; q < 100; ++q) {
            try {
                channel.bind(new InetSocketAddress(this.localBindAddress, port));
                ex = null;
                break;
            }
            catch (IOException e) {
                ex = e;
                logger.info((Object)("Failed trying to bind " + this.localBindAddress + ":" + port));
                port = this.localPortManager.next();
                continue;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    private void generateTasks() throws IOException {
        for (int i = 0; i < ServiceScheduler.POOL_SIZE; ++i) {
            this.selectors.add(SelectorProvider.provider().openSelector());
            PollTask pollTask = new PollTask(this.selectors.get(i));
            this.pollTasks.add(pollTask);
            ScheduledFuture future = this.scheduler.scheduleWithFixedDelay((Runnable)pollTask, 0L, 2L, TimeUnit.MILLISECONDS);
            this.pollTaskFutures.add(future);
        }
    }

    private void stopTasks() {
        for (Future<?> future : this.pollTaskFutures) {
            future.cancel(false);
        }
        this.pollTaskFutures.clear();
    }

    private void closeSelectors() {
        for (int i = 0; i < this.selectors.size(); ++i) {
            Selector selector = this.selectors.get(i);
            if (selector == null || !selector.isOpen()) continue;
            try {
                selector.close();
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("Could not close selector " + i), (Throwable)e);
            }
        }
    }

    private void cleanResources() {
        this.pollTasks.clear();
        this.selectors.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.active) {
                this.active = true;
                logger.info((Object)"Starting UDP Manager");
                try {
                    this.generateTasks();
                    logger.info((Object)("Initialized UDP interface[" + this.inet + "]: bind address=" + this.bindAddress));
                }
                catch (IOException e) {
                    logger.error((Object)"An error occurred while initializing the polling tasks", (Throwable)e);
                    this.stop();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.active) {
                this.active = false;
                logger.info((Object)"Stopping UDP Manager");
                this.stopTasks();
                this.closeSelectors();
                this.cleanResources();
                logger.info((Object)"UDP Manager has stopped");
            }
        }
    }

    private class PollTask
    implements Runnable {
        private final Selector localSelector;

        public PollTask(Selector selector) {
            this.localSelector = selector;
        }

        @Override
        public void run() {
            if (UdpManager.this.active) {
                try {
                    int selected = this.localSelector.selectNow();
                    if (selected == 0) {
                        return;
                    }
                }
                catch (IOException e) {
                    logger.error((Object)"Could not select channels from Selector!");
                }
                Iterator<SelectionKey> it = this.localSelector.selectedKeys().iterator();
                while (it.hasNext() && UdpManager.this.active) {
                    SelectionKey key = it.next();
                    it.remove();
                    DatagramChannel udpChannel = (DatagramChannel)key.channel();
                    Object attachment = key.attachment();
                    if (attachment == null) continue;
                    try {
                        Object channel;
                        if (attachment instanceof ProtocolHandler) {
                            ProtocolHandler handler = (ProtocolHandler)key.attachment();
                            if (!udpChannel.isOpen()) {
                                handler.onClosed();
                                continue;
                            }
                            if (!key.isReadable()) continue;
                            handler.receive(udpChannel);
                            continue;
                        }
                        if (attachment instanceof Channel) {
                            channel = (Channel)attachment;
                            if (udpChannel.isOpen()) {
                                if (!key.isValid()) continue;
                                channel.receive();
                                if (!channel.hasPendingData()) continue;
                                channel.send();
                                continue;
                            }
                            channel.close();
                            continue;
                        }
                        if (!(attachment instanceof NetworkChannel)) continue;
                        channel = (NetworkChannel)attachment;
                        if (udpChannel.isOpen()) {
                            if (!key.isValid()) continue;
                            channel.receive();
                            continue;
                        }
                        channel.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"An unexpected problem occurred while reading from channel.", (Throwable)e);
                    }
                }
                this.localSelector.selectedKeys().clear();
            }
        }
    }
}

