/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.network.deprecated.channel;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;
import org.restcomm.media.network.deprecated.channel.Channel;
import org.restcomm.media.network.deprecated.channel.PacketHandler;
import org.restcomm.media.network.deprecated.channel.PacketHandlerException;
import org.restcomm.media.network.deprecated.channel.PacketHandlerPipeline;

@Deprecated
public class MultiplexedChannel
implements Channel {
    private static final Logger logger = Logger.getLogger(MultiplexedChannel.class);
    protected SelectionKey selectionKey;
    protected DatagramChannel dataChannel;
    protected final PacketHandlerPipeline handlers = new PacketHandlerPipeline();
    private static final int BUFFER_SIZE = 8192;
    private final ByteBuffer receiveBuffer;
    private final Queue<byte[]> pendingData = new ConcurrentLinkedQueue<byte[]>();

    public MultiplexedChannel() {
        this.receiveBuffer = ByteBuffer.allocateDirect(8192);
    }

    @Override
    public SocketAddress getLocalAddress() {
        if (this.isOpen()) {
            try {
                return this.dataChannel.getLocalAddress();
            }
            catch (IOException e) {
                logger.error((Object)("Could not get local addres of the data channel: " + e.getMessage()));
            }
        }
        return null;
    }

    @Override
    public String getLocalHost() {
        if (this.dataChannel != null && this.dataChannel.isOpen()) {
            try {
                return ((InetSocketAddress)this.dataChannel.getLocalAddress()).getHostString();
            }
            catch (IOException e) {
                logger.error((Object)("Could not lookup the local channel address: " + e.getMessage()), (Throwable)e);
            }
        }
        return "";
    }

    @Override
    public int getLocalPort() {
        if (this.dataChannel != null && this.dataChannel.isOpen()) {
            return this.dataChannel.socket().getLocalPort();
        }
        return 0;
    }

    public String getRemoteHost() {
        if (this.dataChannel != null && this.dataChannel.isConnected()) {
            try {
                return ((InetSocketAddress)this.dataChannel.getRemoteAddress()).getHostString();
            }
            catch (IOException e) {
                logger.error((Object)"Could not lookup the remote peer address", (Throwable)e);
            }
        }
        return "";
    }

    public int getRemotePort() {
        if (this.dataChannel != null && this.dataChannel.isConnected()) {
            try {
                return ((InetSocketAddress)this.dataChannel.getRemoteAddress()).getPort();
            }
            catch (IOException e) {
                logger.error((Object)"Could not lookup the remote peer port", (Throwable)e);
            }
        }
        return 0;
    }

    @Deprecated
    public void setTransport(DatagramChannel channel) {
        this.dataChannel = channel;
    }

    protected void queueData(byte[] data) {
        if (data != null && data.length > 0) {
            this.pendingData.offer(data);
        }
    }

    @Override
    public boolean hasPendingData() {
        return !this.pendingData.isEmpty();
    }

    protected void flush() {
        try {
            this.receiveBuffer.clear();
            SocketAddress currAddress = null;
            do {
                if (this.dataChannel != null && this.dataChannel.isOpen()) {
                    currAddress = this.dataChannel.receive(this.receiveBuffer);
                    this.receiveBuffer.clear();
                    continue;
                }
                currAddress = null;
            } while (currAddress != null);
        }
        catch (Exception e) {
            logger.warn((Object)("Stopped flushing the channel abruptly: " + e.getMessage()));
        }
    }

    @Override
    public void receive() throws IOException {
        this.receiveBuffer.clear();
        int dataLength = 0;
        try {
            SocketAddress remotePeer = this.dataChannel.receive(this.receiveBuffer);
            if (!this.isConnected() && remotePeer != null) {
                this.connect(remotePeer);
            }
            dataLength = this.receiveBuffer.position();
        }
        catch (IOException e) {
            dataLength = -1;
        }
        if (dataLength == -1) {
            this.close();
            return;
        }
        if (dataLength > 0) {
            byte[] dataCopy = new byte[dataLength];
            this.receiveBuffer.rewind();
            this.receiveBuffer.get(dataCopy, 0, dataLength);
            PacketHandler handler = this.handlers.getHandler(dataCopy);
            if (handler != null) {
                try {
                    byte[] response = handler.handle(dataCopy, dataLength, 0, (InetSocketAddress)this.dataChannel.getLocalAddress(), (InetSocketAddress)this.dataChannel.getRemoteAddress());
                    if (response != null && response.length > 0) {
                        this.queueData(response);
                    }
                }
                catch (PacketHandlerException e) {
                    logger.error((Object)("Could not handle incoming packet: " + e.getMessage()));
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)"No protocol handler was found to process an incoming packet. Packet will be dropped.");
            }
        }
    }

    @Override
    public void send() throws IOException {
        byte[] data = this.pendingData.poll();
        if (data != null) {
            ByteBuffer buffer = ByteBuffer.wrap(data);
            this.dataChannel.send(buffer, this.dataChannel.getRemoteAddress());
            this.send();
        }
    }

    @Override
    public boolean isOpen() {
        if (this.dataChannel != null) {
            return this.dataChannel.isOpen();
        }
        return false;
    }

    @Override
    public boolean isConnected() {
        return this.dataChannel != null && this.dataChannel.isConnected();
    }

    @Override
    public void bind(SocketAddress address) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("The channel is closed.");
        }
        this.dataChannel.bind(address);
    }

    @Override
    public void connect(SocketAddress address) throws IOException {
        if (this.dataChannel == null) {
            throw new IOException("No channel available to connect.");
        }
        this.dataChannel.connect(address);
    }

    @Override
    public void disconnect() throws IOException {
        if (this.isConnected()) {
            this.dataChannel.disconnect();
        }
    }

    @Override
    public void open() throws IOException {
        if (this.dataChannel != null && this.dataChannel.isOpen()) {
            throw new IOException("Channel is already open.");
        }
        this.dataChannel = DatagramChannel.open();
    }

    @Override
    public void open(DatagramChannel dataChannel) throws IOException {
        if (dataChannel == null) {
            throw new IOException("The data channel cannot be null.");
        }
        if (!dataChannel.isOpen()) {
            throw new IOException("The data channel is closed.");
        }
        this.dataChannel = dataChannel;
    }

    @Override
    public void close() {
        if (this.isOpen()) {
            if (this.isConnected()) {
                try {
                    this.dataChannel.disconnect();
                }
                catch (IOException e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
            try {
                this.selectionKey.cancel();
                this.dataChannel.socket().close();
                this.dataChannel.close();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

