/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.pcap;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import net.ripe.hadoop.pcap.PcapReader;
import net.ripe.hadoop.pcap.packet.Packet;
import org.restcomm.media.pcap.GenericPcapReader;

public class PcapFile
implements Closeable {
    private static final String PCAP_REGEX = ".+\\.p?cap(.gz(ip)?)?";
    private static final String GZIP_REGEX = ".+\\.gz(ip)?";
    private final URL path;
    private final boolean compressed;
    private InputStream inputStream;
    private PcapReader reader;

    public PcapFile(URL path) {
        if (!path.toString().matches(PCAP_REGEX)) {
            throw new IllegalArgumentException("Unsupported extension: " + path.toString());
        }
        this.path = path;
        this.compressed = path.toString().matches(GZIP_REGEX);
    }

    public URL getPath() {
        return this.path;
    }

    public void open() throws IOException {
        this.inputStream = this.path.openStream();
        if (this.compressed) {
            this.inputStream = new GZIPInputStream(this.inputStream);
        }
        this.reader = new GenericPcapReader(new DataInputStream(this.inputStream));
    }

    public Packet read() {
        Iterator iterator;
        if (this.reader != null && (iterator = this.reader.iterator()).hasNext()) {
            return (Packet)iterator.next();
        }
        return null;
    }

    public boolean isComplete() {
        return !this.reader.iterator().hasNext();
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader = null;
        }
        if (this.inputStream != null) {
            this.inputStream.close();
        }
    }
}

