/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.pcap;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.ripe.hadoop.pcap.packet.Packet;
import org.apache.log4j.Logger;
import org.restcomm.media.pcap.AsyncPcapChannel;
import org.restcomm.media.pcap.PcapFile;
import org.restcomm.media.pcap.PcapPlayerContext;

public class PcapPlayer {
    private static final Logger log = Logger.getLogger(PcapPlayer.class);
    private final ListeningScheduledExecutorService scheduler;
    private final AsyncPcapChannel channel;
    private final AtomicBoolean playing;
    private final PcapPlayerContext context;

    public PcapPlayer(AsyncPcapChannel channel, ListeningScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
        this.channel = channel;
        this.playing = new AtomicBoolean(false);
        this.context = new PcapPlayerContext();
    }

    private PcapFile loadFile(URL filepath) throws IOException {
        PcapFile pcapFile = new PcapFile(filepath);
        try {
            pcapFile.open();
        }
        catch (IOException e) {
            try {
                pcapFile.close();
            }
            catch (IOException e2) {
                log.warn((Object)("Could not close PCAP file " + filepath + " elegantly."), (Throwable)e2);
            }
            throw e;
        }
        return pcapFile;
    }

    private void scheduleRead(long time, TimeUnit unit) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Scheduled PCAP packet playback for " + time + " " + unit.name()));
        }
        ListenableScheduledFuture future = this.scheduler.schedule((Callable)new PlayerWorker(), time, TimeUnit.MICROSECONDS);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new PlayerWorkerCallback(), (Executor)this.scheduler);
    }

    public void play(URL filepath) throws IOException {
        if (this.playing.get()) {
            throw new IllegalStateException("PCAP Player is busy.");
        }
        this.context.reset();
        PcapFile pcap = this.loadFile(filepath);
        this.context.setPcapFile(pcap);
        this.playing.set(true);
        if (pcap.isComplete()) {
            this.stop();
        } else {
            Packet packet = pcap.read();
            this.context.setSuspendedPcapPacket(packet);
            this.scheduleRead(0L, TimeUnit.MICROSECONDS);
        }
    }

    public void stop() {
        if (this.playing.compareAndSet(true, false)) {
            try {
                this.context.getPcapFile().close();
            }
            catch (IOException e) {
                log.warn((Object)("Could not close PCAP file " + this.context.getPcapFile().toString()), (Throwable)e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Stopped playing PCAP " + this.context.getPcapFile().getPath()));
            }
        }
    }

    public boolean isPlaying() {
        return this.playing.get();
    }

    public int countPacketsSent() {
        return this.context.getPacketsSent();
    }

    public int countOctetsSent() {
        return this.context.getOctetsSent();
    }

    private final class ChannelSendCallback
    implements FutureCallback<Void> {
        private ChannelSendCallback() {
        }

        private void scheduleNextRead() {
            PcapFile pcap = PcapPlayer.this.context.getPcapFile();
            if (pcap.isComplete()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Reached end of PCAP " + pcap.getPath().toString() + ". Player will stop."));
                }
                PcapPlayer.this.stop();
            } else {
                Packet nextPacket = pcap.read();
                PcapPlayer.this.context.setSuspendedPcapPacket(nextPacket);
                long nextPacketPlaybackTimestampSeconds = (Long)nextPacket.get((Object)"ts");
                long nextPacketPlaybackTimestampMicros = (Long)nextPacket.get((Object)"ts_micros");
                long nextPacketPlaybackTimestamp = nextPacketPlaybackTimestampSeconds * 1000000L + nextPacketPlaybackTimestampMicros;
                long nextPacketTimestamp = System.nanoTime() / 1000L;
                long timestampWindowframe = nextPacketTimestamp - PcapPlayer.this.context.getLastPacketTimestamp();
                long playbackWindowframe = nextPacketPlaybackTimestamp - PcapPlayer.this.context.getLastPacketPlaybackTimestamp();
                long suspensionTime = playbackWindowframe - timestampWindowframe;
                double latencyCompensation = (double)suspensionTime * PcapPlayer.this.context.getLatencyCompensationFactor();
                suspensionTime = (long)((double)suspensionTime - latencyCompensation);
                PcapPlayer.this.scheduleRead(Math.max(0L, suspensionTime), TimeUnit.MICROSECONDS);
            }
        }

        public void onSuccess(Void result) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Sent PCAP RTP packet to remote peer");
            }
            if (PcapPlayer.this.playing.get()) {
                this.scheduleNextRead();
            }
        }

        public void onFailure(Throwable t) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Failed to send PCAP RTP packet to remote peer", t);
            }
            if (PcapPlayer.this.playing.get()) {
                this.scheduleNextRead();
            }
        }
    }

    private final class PlayerWorkerCallback
    implements FutureCallback<Packet> {
        private PlayerWorkerCallback() {
        }

        public void onSuccess(Packet result) {
            if (result != null) {
                PcapPlayer.this.context.packetSent(result);
                if (log.isTraceEnabled()) {
                    int packetsSent = PcapPlayer.this.context.getPacketsSent();
                    int octetsSent = PcapPlayer.this.context.getOctetsSent();
                    URL pcapPath = PcapPlayer.this.context.getPcapFile().getPath();
                    log.info((Object)("PCAP Playback Statistics for " + pcapPath.toString() + " [packets_sent = " + packetsSent + ", octets sent=" + octetsSent + "]"));
                }
            }
        }

        public void onFailure(Throwable t) {
            log.warn((Object)"Could not play PCAP frame. Aborting play operation.", t);
            if (PcapPlayer.this.playing.get()) {
                PcapPlayer.this.stop();
            }
        }
    }

    private final class PlayerWorker
    implements Callable<Packet> {
        private final ChannelSendCallback sendCallback;

        public PlayerWorker() {
            this.sendCallback = new ChannelSendCallback();
        }

        @Override
        public Packet call() {
            Packet packet = null;
            if (PcapPlayer.this.playing.get()) {
                packet = PcapPlayer.this.context.getSuspendedPcapPacket();
                PcapPlayer.this.channel.send(packet, this.sendCallback);
                PcapPlayer.this.context.setSuspendedPcapPacket(null);
                PcapPlayer.this.context.setLastPacketPlaybackTimestamp((Long)packet.get((Object)"ts") * 1000000L + (Long)packet.get((Object)"ts_micros"));
                PcapPlayer.this.context.setLastPacketTimestamp(System.nanoTime() / 1000L);
            }
            return packet;
        }
    }
}

