/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.pcap;

import java.io.InputStream;
import net.ripe.hadoop.pcap.packet.Packet;
import org.restcomm.media.pcap.PcapFile;

public class PcapPlayerContext {
    private PcapFile pcapFile = null;
    private InputStream pcapInputStream = null;
    private long lastPacketTimestamp = 0L;
    private long lastPacketPlaybackTimestamp = -4294967295L;
    private Packet suspendedPcapPacket = null;
    private double latencyCompensationFactor = 0.15;
    private int packetsSent = 0;
    private int octetsSent = 0;

    public PcapFile getPcapFile() {
        return this.pcapFile;
    }

    public void setPcapFile(PcapFile pcapFile) {
        this.pcapFile = pcapFile;
    }

    public InputStream getPcapInputStream() {
        return this.pcapInputStream;
    }

    public void setPcapInputStream(InputStream pcapInputStream) {
        this.pcapInputStream = pcapInputStream;
    }

    public long getLastPacketTimestamp() {
        return this.lastPacketTimestamp;
    }

    public void setLastPacketTimestamp(long lastPacketTimestamp) {
        this.lastPacketTimestamp = lastPacketTimestamp;
    }

    public long getLastPacketPlaybackTimestamp() {
        return this.lastPacketPlaybackTimestamp;
    }

    public void setLastPacketPlaybackTimestamp(long lastPacketPlaybackTimestamp) {
        this.lastPacketPlaybackTimestamp = lastPacketPlaybackTimestamp;
    }

    public Packet getSuspendedPcapPacket() {
        return this.suspendedPcapPacket;
    }

    public void setSuspendedPcapPacket(Packet suspendedPcapPacket) {
        this.suspendedPcapPacket = suspendedPcapPacket;
    }

    public double getLatencyCompensationFactor() {
        return this.latencyCompensationFactor;
    }

    public void setLatencyCompensationFactor(double latencyCompensationFactor) {
        this.latencyCompensationFactor = latencyCompensationFactor;
    }

    public int getPacketsSent() {
        return this.packetsSent;
    }

    public int getOctetsSent() {
        return this.octetsSent;
    }

    public void packetSent(Packet packet) {
        ++this.packetsSent;
        this.octetsSent += ((Integer)packet.get((Object)"udp_length")).intValue();
    }

    public void reset() {
        this.pcapFile = null;
        this.pcapInputStream = null;
        this.lastPacketTimestamp = 0L;
        this.lastPacketPlaybackTimestamp = -4294967295L;
        this.suspendedPcapPacket = null;
        this.packetsSent = 0;
        this.octetsSent = 0;
    }
}

