/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.resource.dtmf;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;
import org.restcomm.media.ComponentType;
import org.restcomm.media.component.AbstractSink;
import org.restcomm.media.component.audio.AudioOutput;
import org.restcomm.media.component.audio.GoertzelFilter;
import org.restcomm.media.component.oob.OOBOutput;
import org.restcomm.media.resource.dtmf.DtmfBuffer;
import org.restcomm.media.resource.dtmf.DtmfEventImpl;
import org.restcomm.media.scheduler.PriorityQueueScheduler;
import org.restcomm.media.scheduler.Task;
import org.restcomm.media.spi.dtmf.DtmfDetector;
import org.restcomm.media.spi.dtmf.DtmfDetectorListener;
import org.restcomm.media.spi.format.Format;
import org.restcomm.media.spi.format.FormatFactory;
import org.restcomm.media.spi.format.Formats;
import org.restcomm.media.spi.listener.Event;
import org.restcomm.media.spi.listener.Listener;
import org.restcomm.media.spi.listener.Listeners;
import org.restcomm.media.spi.listener.TooManyListenersException;
import org.restcomm.media.spi.memory.Frame;
import org.restcomm.media.spi.pooling.PooledObject;

public class DetectorImpl
extends AbstractSink
implements DtmfDetector,
PooledObject {
    private static final long serialVersionUID = 450306501541827622L;
    private static final Format linear = FormatFactory.createAudioFormat((String)"linear", (int)8000, (int)16, (int)1);
    private static final Formats formats = new Formats();
    private static final int TONE_DURATION = 80;
    public static final String[][] events;
    private static final String[] oobEvtID;
    private static final int[] lowFreq;
    private static final int[] highFreq;
    private GoertzelFilter[] lowFreqFilters = new GoertzelFilter[4];
    private GoertzelFilter[] highFreqFilters = new GoertzelFilter[4];
    private double threshold = 0.0;
    private int level;
    private int offset = 0;
    private int toneDuration = 80;
    private int N = 8 * this.toneDuration;
    private double scale = (double)this.toneDuration / 1000.0;
    private double[] p = new double[4];
    private double[] P = new double[4];
    private double[] signal;
    private double maxAmpl;
    private DtmfBuffer dtmfBuffer;
    private Listeners<DtmfDetectorListener> listeners = new Listeners();
    private EventSender eventSender;
    private PriorityQueueScheduler scheduler;
    private AudioOutput output;
    private OOBOutput oobOutput;
    private OOBDetector oobDetector;
    private static final Logger logger;

    public DetectorImpl(String name, PriorityQueueScheduler scheduler) {
        super(name);
        this.scheduler = scheduler;
        this.dtmfBuffer = new DtmfBuffer(this);
        this.eventSender = new EventSender();
        this.signal = new double[this.N];
        for (int i = 0; i < 4; ++i) {
            this.lowFreqFilters[i] = new GoertzelFilter(lowFreq[i], this.N, this.scale);
            this.highFreqFilters[i] = new GoertzelFilter(highFreq[i], this.N, this.scale);
        }
        this.level = -30;
        this.output = new AudioOutput(scheduler, ComponentType.DTMF_DETECTOR.getType());
        this.oobOutput = new OOBOutput(scheduler, ComponentType.DTMF_DETECTOR.getType());
        this.output.join((AbstractSink)this);
        this.oobDetector = new OOBDetector();
        this.oobOutput.join((AbstractSink)this.oobDetector);
    }

    public AudioOutput getAudioOutput() {
        return this.output;
    }

    public OOBOutput getOOBOutput() {
        return this.oobOutput;
    }

    public void activate() {
        this.offset = 0;
        this.maxAmpl = 0.0;
        this.dtmfBuffer.clear();
        this.output.start();
        this.oobOutput.start();
    }

    public void deactivate() {
        this.output.stop();
        this.oobOutput.stop();
    }

    public void setDuration(int duartion) {
        this.toneDuration = duartion;
    }

    public int getDuration() {
        return this.toneDuration;
    }

    public void setVolume(int level) {
        this.level = level;
        this.threshold = Math.pow(Math.pow(10.0, level), 0.1) * 32767.0;
    }

    public void setLasy(boolean isLazy) {
    }

    public int getVolume() {
        return this.level;
    }

    public void onMediaTransfer(Frame buffer) throws IOException {
        byte[] data = buffer.getData();
        int M = buffer.getLength();
        int k = 0;
        while (k < M) {
            while (this.offset < this.N && k < M - 1) {
                int n = k++;
                int n2 = k++;
                double s = data[n] & 0xFF | data[n2] << 8;
                double sa = Math.abs(s);
                if (sa > this.maxAmpl) {
                    this.maxAmpl = sa;
                }
                this.signal[this.offset++] = s;
            }
            if (this.offset != this.N) continue;
            this.offset = 0;
            if (!(this.maxAmpl >= this.threshold)) continue;
            this.maxAmpl = 0.0;
            this.getPower(this.lowFreqFilters, this.signal, 0, this.p);
            this.getPower(this.highFreqFilters, this.signal, 0, this.P);
            String tone = this.getTone(this.p, this.P);
            if (tone == null) continue;
            this.dtmfBuffer.push(tone);
        }
    }

    private void getPower(GoertzelFilter[] filters, double[] data, int offset, double[] power) {
        for (int i = 0; i < 4; ++i) {
            power[i] = filters[i].getPower(data, offset);
        }
    }

    private int getMax(double[] data) {
        int idx = 0;
        double max = data[0];
        for (int i = 1; i < data.length; ++i) {
            if (!(max < data[i])) continue;
            max = data[i];
            idx = i;
        }
        return idx;
    }

    private String getTone(double[] f, double[] F) {
        int fm = this.getMax(f);
        boolean fd = true;
        for (int i = 0; i < f.length; ++i) {
            double r;
            if (fm == i || !((r = f[fm] / (f[i] + 1.0E-15)) < this.threshold)) continue;
            fd = false;
            break;
        }
        if (!fd) {
            return null;
        }
        int Fm = this.getMax(F);
        boolean Fd = true;
        for (int i = 0; i < F.length; ++i) {
            double r;
            if (Fm == i || !((r = F[Fm] / (F[i] + 1.0E-15)) < this.threshold)) continue;
            Fd = false;
            break;
        }
        if (!Fd) {
            return null;
        }
        return events[fm][Fm];
    }

    public Formats getNativeFormats() {
        return formats;
    }

    public String getMask() {
        return null;
    }

    public void setMask(String mask) {
    }

    public void setInterdigitInterval(int interval) {
        this.dtmfBuffer.setInterdigitInterval(interval);
    }

    public int getInterdigitInterval() {
        return this.dtmfBuffer.getInterdigitInterval();
    }

    protected void fireEvent(String tone) {
        this.eventSender.events.add(new DtmfEventImpl(this, tone, 0));
        this.scheduler.submit((Task)this.eventSender, PriorityQueueScheduler.INPUT_QUEUE);
    }

    protected void fireEvent(DtmfEventImpl evt) {
        this.eventSender.events.add(evt);
        this.scheduler.submit((Task)this.eventSender, PriorityQueueScheduler.INPUT_QUEUE);
    }

    protected void fireEvent(Collection<DtmfEventImpl> evts) {
        this.eventSender.events.addAll(evts);
        this.scheduler.submit((Task)this.eventSender, PriorityQueueScheduler.INPUT_QUEUE);
    }

    public void flushBuffer() {
        this.dtmfBuffer.flush();
    }

    public void clearBuffer() {
        this.dtmfBuffer.clear();
    }

    public void addListener(DtmfDetectorListener listener) throws TooManyListenersException {
        this.listeners.add((Listener)listener);
    }

    public void removeListener(DtmfDetectorListener listener) {
        this.listeners.remove((Listener)listener);
    }

    public void clearAllListeners() {
        this.listeners.clear();
    }

    public void clearDigits() {
        this.dtmfBuffer.clear();
    }

    public void checkIn() {
    }

    public void checkOut() {
    }

    static {
        formats.add(linear);
        events = new String[][]{{"1", "2", "3", "A"}, {"4", "5", "6", "B"}, {"7", "8", "9", "C"}, {"*", "0", "#", "D"}};
        oobEvtID = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "*", "#", "A", "B", "C", "D"};
        lowFreq = new int[]{697, 770, 852, 941};
        highFreq = new int[]{1209, 1336, 1477, 1633};
        logger = Logger.getLogger(DetectorImpl.class);
    }

    private class OOBDetector
    extends AbstractSink {
        private static final long serialVersionUID = -1065228790095547415L;
        private byte currTone;
        private long latestSeq;
        private boolean hasEndOfEvent;
        private long endSeq;

        public OOBDetector() {
            super("oob detector");
            this.currTone = (byte)-1;
            this.latestSeq = 0L;
            this.hasEndOfEvent = false;
            this.endSeq = 0L;
        }

        public void onMediaTransfer(Frame buffer) throws IOException {
            byte[] data = buffer.getData();
            if (data.length != 4) {
                return;
            }
            boolean endOfEvent = false;
            boolean bl = endOfEvent = (data[1] & 0x80) != 0;
            if (endOfEvent) {
                this.hasEndOfEvent = true;
                this.endSeq = buffer.getSequenceNumber();
                return;
            }
            if (this.currTone == data[0]) {
                if (this.hasEndOfEvent) {
                    if (buffer.getSequenceNumber() <= this.endSeq && buffer.getSequenceNumber() > this.endSeq - 8L) {
                        return;
                    }
                } else if (buffer.getSequenceNumber() < this.latestSeq + 8L && buffer.getSequenceNumber() > this.latestSeq - 8L) {
                    if (buffer.getSequenceNumber() > this.latestSeq) {
                        this.latestSeq = buffer.getSequenceNumber();
                    }
                    return;
                }
            }
            this.hasEndOfEvent = false;
            this.endSeq = 0L;
            this.latestSeq = buffer.getSequenceNumber();
            this.currTone = data[0];
            DetectorImpl.this.dtmfBuffer.push(oobEvtID[this.currTone]);
        }

        public void activate() {
        }

        public void deactivate() {
        }
    }

    public class EventSender
    extends Task {
        private final Queue<DtmfEventImpl> events = new ConcurrentLinkedQueue<DtmfEventImpl>();

        public int getQueueNumber() {
            return PriorityQueueScheduler.INPUT_QUEUE;
        }

        public long perform() {
            Iterator iterator = this.events.iterator();
            while (iterator.hasNext()) {
                DtmfEventImpl evt = (DtmfEventImpl)iterator.next();
                if (!DetectorImpl.this.listeners.dispatch((Event)evt)) {
                    DetectorImpl.this.dtmfBuffer.queue(evt);
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)String.format("(%s) Buffered '%s' tone", DetectorImpl.this.getName(), evt.getTone()));
                    }
                } else if (logger.isInfoEnabled()) {
                    logger.info((Object)String.format("(%s) Delivered '%s' tone", DetectorImpl.this.getName(), evt.getTone()));
                }
                iterator.remove();
            }
            return 0L;
        }
    }
}

