/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.resource.dtmf.util;

public class NtpTimeStampUtil {
    private static final long msb0baseTime = 2085978496000L;
    private static final long msb1baseTime = -2208988800000L;
    private static long[] time = new long[2];

    public static long getTime(long seconds, long fraction) {
        fraction = Math.round(1000.0 * (double)fraction / 4.294967296E9);
        long msb = seconds & 0x80000000L;
        if (msb == 0L) {
            return 2085978496000L + seconds * 1000L + fraction;
        }
        return -2208988800000L + seconds * 1000L + fraction;
    }

    public static long[] toNtpTime(long t) {
        boolean useBase1 = t < 2085978496000L;
        long baseTime = useBase1 ? t - -2208988800000L : t - 2085978496000L;
        long seconds = baseTime / 1000L;
        long fraction = baseTime % 1000L * 0x100000000L / 1000L;
        if (useBase1) {
            seconds |= 0x80000000L;
        }
        NtpTimeStampUtil.time[0] = seconds;
        NtpTimeStampUtil.time[1] = fraction;
        return time;
    }
}

