/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.resource.player.audio.gsm;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.log4j.Logger;
import org.restcomm.media.resource.player.Track;
import org.restcomm.media.spi.format.AudioFormat;
import org.restcomm.media.spi.format.Format;
import org.restcomm.media.spi.format.FormatFactory;
import org.restcomm.media.spi.memory.Frame;
import org.restcomm.media.spi.memory.Memory;

public class GsmTrackImpl
implements Track {
    private static final AudioFormat.Encoding GSM_ENCODING = new AudioFormat.Encoding("GSM0610");
    private transient AudioInputStream stream = null;
    private InputStream inStream;
    private AudioFormat format;
    private int period = 20;
    private int frameSize;
    private boolean eom;
    private long duration;
    private long timestamp;
    private static final Logger logger = Logger.getLogger(GsmTrackImpl.class);

    public GsmTrackImpl(URL url) throws UnsupportedAudioFileException, IOException {
        this.inStream = url.openStream();
        this.stream = AudioSystem.getAudioInputStream(this.inStream);
        this.format = this.getFormat(this.stream);
        if (this.format == null) {
            this.stream.close();
            this.inStream.close();
            throw new UnsupportedAudioFileException();
        }
        this.duration = (long)((float)this.stream.getFrameLength() / this.stream.getFormat().getFrameRate() * 1000.0f);
        this.frameSize = 33;
    }

    public void setPeriod(int period) {
        throw new IllegalArgumentException("Period can not be changed");
    }

    public int getPeriod() {
        return this.period;
    }

    private AudioFormat getFormat(AudioInputStream stream) {
        AudioFormat.Encoding encoding = stream.getFormat().getEncoding();
        if (encoding.equals(GSM_ENCODING)) {
            return FormatFactory.createAudioFormat((String)"gsm", (int)8000);
        }
        return null;
    }

    @Override
    public long getMediaTime() {
        return this.timestamp;
    }

    @Override
    public void setMediaTime(long timestamp) {
        this.timestamp = timestamp;
        try {
            this.stream.reset();
            long offset = (long)this.frameSize * (timestamp / (long)this.period);
            this.stream.skip(offset);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    private int readPacket(byte[] packet, int offset, int psize) throws IOException {
        int length;
        try {
            int len;
            for (length = 0; length < psize; length += len) {
                len = this.stream.read(packet, offset + length, psize - length);
                if (len != -1) continue;
                return length;
            }
            return length;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return length;
        }
    }

    private void padding(byte[] data, int count) {
        int offset = data.length - count;
        for (int i = 0; i < count; ++i) {
            data[i + offset] = 0;
        }
    }

    @Override
    public Frame process(long timestamp) throws IOException {
        Frame frame = Memory.allocate((int)this.frameSize);
        byte[] data = frame.getData();
        int len = this.readPacket(data, 0, this.frameSize);
        if (len == 0) {
            this.eom = true;
        }
        if (len < this.frameSize) {
            this.padding(data, this.frameSize - len);
            this.eom = true;
        }
        frame.setOffset(0);
        frame.setLength(this.frameSize);
        frame.setEOM(this.eom);
        frame.setDuration((long)this.period);
        timestamp += (long)this.period;
        return frame;
    }

    @Override
    public void close() {
        try {
            this.stream.close();
            this.inStream.close();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    @Override
    public Format getFormat() {
        return this.format;
    }
}

